/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class FontUtils {
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public static final String[] prefixes = new String[]{"K", "M", "G"};

    public static void drawCenteredString(String s, int xCenter, int y, int colour) {
        fontRenderer.func_211126_b(s, (float)(xCenter - fontRenderer.func_78256_a(s) / 2), (float)y, colour);
    }

    public static void drawRightString(String s, int xRight, int y, int colour) {
        fontRenderer.func_211126_b(s, (float)(xRight - fontRenderer.func_78256_a(s)), (float)y, colour);
    }

    public static void drawItemQuantity(int x, int y, @Nonnull ItemStack item, String quantity, int mode) {
        if (item.func_190926_b() || quantity == null && item.func_190916_E() <= 1) {
            return;
        }
        if (quantity == null) {
            switch (mode) {
                case 2: {
                    int q = item.func_190916_E();
                    String postfix = "";
                    for (int p = 0; p < 3 && q > 1000; q /= 1000, ++p) {
                        postfix = prefixes[p];
                    }
                    quantity = Integer.toString(q) + postfix;
                    break;
                }
                case 1: {
                    quantity = "";
                    if (item.func_190916_E() / 64 > 0) {
                        quantity = quantity + item.func_190916_E() / 64 + "s";
                    }
                    if (item.func_190916_E() % 64 <= 0) break;
                    quantity = quantity + item.func_190916_E() % 64;
                    break;
                }
                default: {
                    quantity = Integer.toString(item.func_190916_E());
                }
            }
        }
        double scale = quantity.length() > 2 ? 0.5 : 1.0;
        double sheight = 8.0 * scale;
        double swidth = (double)fontRenderer.func_78256_a(quantity) * scale;
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((double)(x + 16) - swidth), (double)((double)(y + 16) - sheight), (double)0.0);
        GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
        fontRenderer.func_175063_a(quantity, 0.0f, 0.0f, 0xFFFFFF);
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
    }
}

