/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.math.MathHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class RotationUtils {
    public static Direction getPlacedRotationHorizontal(LivingEntity entity) {
        int facing = MathHelper.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        return RotationUtils.entityRotationToSide(facing).func_176734_d();
    }

    public static Direction getPlacedRotation(BlockPos pos, LivingEntity entity) {
        int entityRotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
        if (Math.abs(entity.field_70165_t - (double)pos.func_177958_n()) < 2.0 && Math.abs(entity.field_70161_v - (double)pos.func_177952_p()) < 2.0) {
            double eyeDistance = entity.field_70163_u + 1.82 - (double)pos.func_177956_o();
            if (eyeDistance > 2.0) {
                return Direction.DOWN;
            }
            if (eyeDistance < 0.0) {
                return Direction.UP;
            }
        }
        return RotationUtils.entityRotationToSide(entityRotation);
    }

    public static Direction getPlacedRotation(BlockPos pos, LivingEntity entity, boolean onlyHorizon) {
        if (onlyHorizon) {
            return RotationUtils.getPlacedRotationHorizontal(entity);
        }
        return RotationUtils.getPlacedRotation(pos, entity);
    }

    public static Direction rotateCounterClockwise(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + facing);
    }

    public static Direction rotateClockwise(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CW facing of " + facing);
    }

    public static Direction rotateForward(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.DOWN;
            }
            case DOWN: {
                return Direction.UP;
            }
            case UP: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.NORTH;
            }
        }
        return Direction.NORTH;
    }

    public static Direction rotateBackwards(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.DOWN;
            }
            case DOWN: {
                return Direction.NORTH;
            }
        }
        return Direction.NORTH;
    }

    public static Direction entityRotationToSide(int rotation) {
        switch (rotation) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.NORTH;
            }
        }
        return Direction.EAST;
    }
}

