/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.render.CCModelState;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformUtils {
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();
    public static final CCModelState DEFAULT_BLOCK;
    public static final CCModelState DEFAULT_ITEM;
    public static final CCModelState DEFAULT_TOOL;
    public static final CCModelState DEFAULT_BOW;
    public static final CCModelState DEFAULT_HANDHELD_ROD;

    public static TRSRTransformation create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TransformUtils.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static TRSRTransformation create(Vector3 transform, Vector3 rotation, Vector3 scale) {
        return TransformUtils.create(transform.vector3f(), rotation.vector3f(), scale.vector3f());
    }

    public static TRSRTransformation create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(transform, TRSRTransformation.quatFromXYZDegrees((Vector3f)rotation), scale, null));
    }

    public static TRSRTransformation flipLeft(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static TRSRTransformation fromMatrix4(Matrix4 matrix4) {
        return new TRSRTransformation(matrix4.toMatrix4f());
    }

    static {
        HashMap<Object, Object> map = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
        TRSRTransformation thirdPerson = TransformUtils.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new CCModelState(map);
        map = new HashMap();
        thirdPerson = TransformUtils.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.HEAD, TransformUtils.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPerson);
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.flipLeft(firstPerson));
        DEFAULT_ITEM = new CCModelState(map);
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new CCModelState(map);
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new CCModelState(map);
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = new CCModelState(map);
    }
}

