/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class VertexDataUtils {
    public static int getPositionElement(VertexFormat format) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            if (!((VertexFormatElement)elements.get(e)).func_177374_g()) continue;
            return e;
        }
        return -1;
    }

    public static int getNormalElement(VertexFormat format) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            if (((VertexFormatElement)elements.get(e)).func_177375_c() != VertexFormatElement.Usage.NORMAL) continue;
            return e;
        }
        return -1;
    }

    public static int getUVElement(VertexFormat format) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            if (((VertexFormatElement)elements.get(e)).func_177375_c() != VertexFormatElement.Usage.UV || ((VertexFormatElement)elements.get(e)).func_177369_e() != 0) continue;
            return e;
        }
        return -1;
    }

    public static int getElement(VertexFormat format, VertexFormatElement element) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            if (!((VertexFormatElement)elements.get(e)).equals((Object)element)) continue;
            return e;
        }
        return -1;
    }

    public static TextureAtlasSprite getSpriteForUV(AtlasTexture textureMap, UV uv) {
        for (TextureAtlasSprite sprite : textureMap.field_94252_e.values()) {
            if (!MathHelper.between(sprite.func_94209_e(), uv.u, sprite.func_94212_f()) || !MathHelper.between(sprite.func_94206_g(), uv.v, sprite.func_94210_h())) continue;
            return sprite;
        }
        return textureMap.func_195424_a(MissingTextureSprite.func_195675_b());
    }

    public static Map<Direction, List<BakedQuad>> sortFaceData(List<BakedQuad> quads) {
        HashMap<Direction, List<BakedQuad>> faceQuadMap = new HashMap<Direction, List<BakedQuad>>();
        for (BakedQuad quad : quads) {
            List faceQuads = faceQuadMap.computeIfAbsent(quad.func_178210_d(), k -> new ArrayList());
            faceQuads.add(quad);
        }
        return faceQuadMap;
    }

    public static void fullyPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.pack((float[])unpackedData[v][e], (int[])packedData, (VertexFormat)format, (int)v, (int)e);
            }
        }
    }

    public static void fullyUnPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        List elements = format.func_177343_g();
        for (int e = 0; e < elements.size(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.unpack((int[])packedData, (float[])unpackedData[v][e], (VertexFormat)format, (int)v, (int)e);
            }
        }
    }

    public static float[][] unpackElements(int[] packed, VertexFormat format, VertexFormatElement element) {
        float[][] data = new float[4][4];
        int e = VertexDataUtils.getElement(format, element);
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])packed, (float[])data[v], (VertexFormat)format, (int)v, (int)e);
        }
        return data;
    }

    public static BakedQuad buildQuad(VertexFormat format, TextureAtlasSprite sprite, Direction face, Colour colour, UVTransformation t, Vertex5 v1, Vertex5 v2, Vertex5 v3, Vertex5 v4) {
        return null;
    }

    private static float[] diffuseFaceLight(Direction face, float[] colour) {
        double diffuse;
        switch (face) {
            case DOWN: {
                diffuse = 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                diffuse = 0.8;
                break;
            }
            case WEST: 
            case EAST: {
                diffuse = 0.6;
                break;
            }
            default: {
                diffuse = 1.0;
            }
        }
        colour[0] = (float)((double)colour[0] * diffuse);
        colour[1] = (float)((double)colour[1] * diffuse);
        colour[2] = (float)((double)colour[2] * diffuse);
        return colour;
    }
}

