/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    private static ThreadLocal<RayTracer> t_inst = new ThreadLocal();

    public static RayTracer instance() {
        RayTracer inst = t_inst.get();
        if (inst == null) {
            inst = new RayTracer();
            t_inst.set(inst);
        }
        return inst;
    }

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public ata rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        if (this.s_side < 0) {
            return null;
        }
        ata mop = new ata(0, 0, 0, this.s_side, this.s_vec.toVec3D());
        mop.a = null;
        return mop;
    }

    public ata rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockCoord pos) {
        ata mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = atb.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
        }
        return mop;
    }

    public ata rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, nn e) {
        ata mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = atb.b;
            mop.g = e;
        }
        return mop;
    }

    public ata rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids) {
        double c_dist = Double.MAX_VALUE;
        ata c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            ata mop = this.rayTraceCuboid(start, end, cuboid);
            if (mop == null || !(this.s_dist < c_dist)) continue;
            mop = new ExtendedMOP(mop, cuboid.data, this.s_dist);
            c_dist = this.s_dist;
            c_hit = mop;
            this.c_cuboid = cuboid;
        }
        return c_hit;
    }

    public ata rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockCoord pos, aqz block) {
        ata mop = this.rayTraceCuboids(start, end, cuboids);
        if (mop != null) {
            mop.a = atb.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
            if (block != null) {
                this.c_cuboid.add(new Vector3(-pos.x, -pos.y, -pos.z)).setBlockBounds(block);
            }
        }
        return mop;
    }

    public void rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockCoord pos, aqz block, List<ExtendedMOP> hitList) {
        for (IndexedCuboid6 cuboid : cuboids) {
            ata mop = this.rayTraceCuboid(start, end, cuboid);
            if (mop == null) continue;
            ExtendedMOP emop = new ExtendedMOP(mop, cuboid.data, this.s_dist);
            emop.a = atb.a;
            emop.b = pos.x;
            emop.c = pos.y;
            emop.d = pos.z;
            hitList.add(emop);
        }
    }

    public static ata retraceBlock(abw world, uf player, int x, int y, int z) {
        aqz block = aqz.s[world.a(x, y, z)];
        if (block == null) {
            return null;
        }
        atc headVec = RayTracer.getCorrectedHeadVec(player);
        atc lookVec = player.j(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        atc endVec = headVec.c(lookVec.c * reach, lookVec.d * reach, lookVec.e * reach);
        return block.a(world, x, y, z, headVec, endVec);
    }

    private static double getBlockReachDistance_server(jv player) {
        return player.c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return atv.w().c.d();
    }

    public static ata reTrace(abw world, uf player) {
        return RayTracer.reTrace(world, player, RayTracer.getBlockReachDistance(player));
    }

    public static ata reTrace(abw world, uf player, double reach) {
        atc headVec = RayTracer.getCorrectedHeadVec(player);
        atc lookVec = player.j(1.0f);
        atc endVec = headVec.c(lookVec.c * reach, lookVec.d * reach, lookVec.e * reach);
        return world.a(headVec, endVec, true, false);
    }

    public static atc getCorrectedHeadVec(uf player) {
        atc v = atc.a((double)player.u, (double)player.v, (double)player.w);
        if (player.q.I) {
            v.d += (double)(player.f() - player.getDefaultEyeHeight());
        } else {
            v.d += (double)player.f();
            if (player instanceof jv && player.ah()) {
                v.d -= 0.08;
            }
        }
        return v;
    }

    public static atc getStartVec(uf player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static double getBlockReachDistance(uf player) {
        return player.q.I ? RayTracer.getBlockReachDistance_client() : (player instanceof jv ? RayTracer.getBlockReachDistance_server((jv)player) : 5.0);
    }

    public static atc getEndVec(uf player) {
        atc headVec = RayTracer.getCorrectedHeadVec(player);
        atc lookVec = player.j(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.c(lookVec.c * reach, lookVec.d * reach, lookVec.e * reach);
    }
}

