/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;

public final class PacketCustom
implements MCDataInput,
MCDataOutput {
    public static AttributeKey<CustomInboundHandler> cclHandler = new AttributeKey("ccl:handler");
    private ByteBuf byteBuf;
    private String channel;
    private int type;

    public static String channelName(Object channelKey) {
        if (channelKey instanceof String) {
            return (String)channelKey;
        }
        if (channelKey instanceof ModContainer) {
            String s = ((ModContainer)channelKey).getModId();
            if (s.length() > 20) {
                throw new IllegalArgumentException("Mod ID (" + s + ") too long for use as channel (20 chars). Use a string identifier");
            }
            return s;
        }
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(channelKey);
        if (mc != null) {
            return mc.getModId();
        }
        throw new IllegalArgumentException("Invalid channel: " + channelKey);
    }

    public static FMLEmbeddedChannel getOrCreateChannel(String channelName, Side side) {
        if (!NetworkRegistry.INSTANCE.hasChannel(channelName, side)) {
            NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new CustomInboundHandler()});
        }
        return NetworkRegistry.INSTANCE.getChannel(channelName, side);
    }

    public static void assignHandler(Object channelKey, ICustomPacketHandler handler) {
        String channelName = PacketCustom.channelName(channelKey);
        Side side = handler instanceof IServerPacketHandler ? Side.SERVER : Side.CLIENT;
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(channelName, side);
        ((CustomInboundHandler)((Object)channel.attr(PacketCustom.cclHandler).get())).handlers.put(side, side == Side.SERVER ? new ServerInboundHandler(handler) : new ClientInboundHandler(handler));
    }

    public static void assignHandshakeHandler(Object channelKey, IHandshakeHandler handler) {
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(PacketCustom.channelName(channelKey), Side.SERVER);
        channel.pipeline().addLast(new ChannelHandler[]{new HandshakeInboundHandler(handler)});
    }

    public PacketCustom(ByteBuf payload) {
        this.byteBuf = payload;
        this.type = this.byteBuf.readUnsignedByte();
        if (this.type > 128) {
            this.decompress();
        }
        this.type &= 0x7F;
    }

    public PacketCustom(Object channelKey, int type) {
        if (type <= 0 || type >= 128) {
            throw new IllegalArgumentException("Packet type: " + type + " is not within required 0 < t < 0x80");
        }
        this.channel = PacketCustom.channelName(channelKey);
        this.type = type;
        this.byteBuf = Unpooled.buffer();
        this.byteBuf.writeByte(type);
    }

    private void decompress() {
        Inflater inflater = new Inflater();
        try {
            int len = this.byteBuf.readInt();
            ByteBuf out = Unpooled.buffer((int)len);
            inflater.setInput(this.byteBuf.array(), this.byteBuf.readerIndex(), this.byteBuf.readableBytes());
            inflater.inflate(out.array());
            out.writerIndex(len);
            this.byteBuf = out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            inflater.end();
        }
    }

    private void do_compress() {
        Deflater deflater = new Deflater();
        try {
            this.byteBuf.readerIndex(1);
            int len = this.byteBuf.readableBytes();
            deflater.setInput(this.byteBuf.array(), this.byteBuf.readerIndex(), len);
            deflater.finish();
            ByteBuf out = Unpooled.buffer((int)(len + 5));
            int clen = deflater.deflate(out.array(), 5, len);
            if (clen >= len - 5 || !deflater.finished()) {
                return;
            }
            out.setByte(0, this.type | 0x80);
            out.setInt(1, len);
            out.writerIndex(clen + 5);
            this.byteBuf = out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.byteBuf.readerIndex(0);
            deflater.end();
        }
    }

    public boolean incoming() {
        return this.channel == null;
    }

    public int getType() {
        return this.type & 0x7F;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public PacketCustom compress() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to compress an incoming packet");
        }
        if ((this.type & 0x80) != 0) {
            throw new IllegalStateException("Packet already compressed");
        }
        this.type |= 0x80;
        return this;
    }

    @Override
    public PacketCustom writeBoolean(boolean b) {
        this.byteBuf.writeBoolean(b);
        return this;
    }

    @Override
    public PacketCustom writeByte(int b) {
        this.byteBuf.writeByte(b);
        return this;
    }

    @Override
    public PacketCustom writeShort(int s) {
        this.byteBuf.writeShort(s);
        return this;
    }

    @Override
    public PacketCustom writeInt(int i) {
        this.byteBuf.writeInt(i);
        return this;
    }

    @Override
    public PacketCustom writeFloat(float f) {
        this.byteBuf.writeFloat(f);
        return this;
    }

    @Override
    public PacketCustom writeDouble(double d) {
        this.byteBuf.writeDouble(d);
        return this;
    }

    @Override
    public PacketCustom writeLong(long l) {
        this.byteBuf.writeLong(l);
        return this;
    }

    @Override
    public PacketCustom writeChar(char c) {
        this.byteBuf.writeChar((int)c);
        return this;
    }

    @Override
    public PacketCustom writeVarInt(int i) {
        ByteBufUtils.writeVarInt((ByteBuf)this.byteBuf, (int)i, (int)5);
        return this;
    }

    @Override
    public PacketCustom writeVarShort(int s) {
        ByteBufUtils.writeVarShort((ByteBuf)this.byteBuf, (int)s);
        return this;
    }

    @Override
    public PacketCustom writeByteArray(byte[] barray) {
        this.byteBuf.writeBytes(barray);
        return this;
    }

    @Override
    public PacketCustom writeString(String s) {
        ByteBufUtils.writeUTF8String((ByteBuf)this.byteBuf, (String)s);
        return this;
    }

    @Override
    public PacketCustom writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public PacketCustom writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public PacketCustom writeItemStack(ItemStack stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public PacketCustom writeItemStack(ItemStack stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            if (large) {
                this.writeInt(stack.field_77994_a);
            } else {
                this.writeByte(stack.field_77994_a);
            }
            this.writeShort(stack.func_77960_j());
            this.writeNBTTagCompound(stack.field_77990_d);
        }
        return this;
    }

    @Override
    public PacketCustom writeNBTTagCompound(NBTTagCompound compound) {
        ByteBufUtils.writeTag((ByteBuf)this.byteBuf, (NBTTagCompound)compound);
        return this;
    }

    @Override
    public PacketCustom writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.fluidID);
            this.writeVarInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }

    @Override
    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    @Override
    public short readUByte() {
        return this.byteBuf.readUnsignedByte();
    }

    @Override
    public int readUShort() {
        return this.byteBuf.readUnsignedShort();
    }

    @Override
    public byte readByte() {
        return this.byteBuf.readByte();
    }

    @Override
    public short readShort() {
        return this.byteBuf.readShort();
    }

    @Override
    public int readInt() {
        return this.byteBuf.readInt();
    }

    @Override
    public float readFloat() {
        return this.byteBuf.readFloat();
    }

    @Override
    public double readDouble() {
        return this.byteBuf.readDouble();
    }

    @Override
    public long readLong() {
        return this.byteBuf.readLong();
    }

    @Override
    public char readChar() {
        return this.byteBuf.readChar();
    }

    @Override
    public int readVarShort() {
        return ByteBufUtils.readVarShort((ByteBuf)this.byteBuf);
    }

    @Override
    public int readVarInt() {
        return ByteBufUtils.readVarInt((ByteBuf)this.byteBuf, (int)5);
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public byte[] readByteArray(int length) {
        byte[] barray = new byte[length];
        this.byteBuf.readBytes(barray, 0, length);
        return barray;
    }

    @Override
    public String readString() {
        return ByteBufUtils.readUTF8String((ByteBuf)this.byteBuf);
    }

    @Override
    public ItemStack readItemStack() {
        return this.readItemStack(false);
    }

    public ItemStack readItemStack(boolean large) {
        ItemStack item = null;
        short itemID = this.readShort();
        if (itemID >= 0) {
            int stackSize = large ? this.readInt() : (int)this.readByte();
            short damage = this.readShort();
            item = new ItemStack(Item.func_150899_d((int)itemID), stackSize, (int)damage);
            item.field_77990_d = this.readNBTTagCompound();
        }
        return item;
    }

    @Override
    public NBTTagCompound readNBTTagCompound() {
        return ByteBufUtils.readTag((ByteBuf)this.byteBuf);
    }

    @Override
    public FluidStack readFluidStack() {
        FluidStack fluid = null;
        short fluidID = this.readShort();
        if (fluidID >= 0) {
            fluid = new FluidStack((int)fluidID, this.readVarInt(), this.readNBTTagCompound());
        }
        return fluid;
    }

    public FMLProxyPacket toPacket() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to write an incoming packet");
        }
        if (this.byteBuf.readableBytes() > 32000 || (this.type & 0x80) != 0) {
            this.do_compress();
        }
        return new FMLProxyPacket(this.byteBuf.copy(), this.channel);
    }

    public void sendToPlayer(EntityPlayer player) {
        PacketCustom.sendToPlayer((Packet)this.toPacket(), player);
    }

    public static void sendToPlayer(Packet packet, EntityPlayer player) {
        if (player == null) {
            PacketCustom.sendToClients(packet);
        } else {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    public void sendToClients() {
        PacketCustom.sendToClients((Packet)this.toPacket());
    }

    public static void sendToClients(Packet packet) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148540_a(packet);
    }

    public void sendPacketToAllAround(double x, double y, double z, double range, int dim) {
        PacketCustom.sendToAllAround((Packet)this.toPacket(), x, y, z, range, dim);
    }

    public static void sendToAllAround(Packet packet, double x, double y, double z, double range, int dim) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148541_a(x, y, z, range, dim, packet);
    }

    public void sendToDimension(int dim) {
        PacketCustom.sendToDimension((Packet)this.toPacket(), dim);
    }

    public static void sendToDimension(Packet packet, int dim) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148537_a(packet, dim);
    }

    public void sendToChunk(World world, int chunkX, int chunkZ) {
        PacketCustom.sendToChunk((Packet)this.toPacket(), world, chunkX, chunkZ);
    }

    public static void sendToChunk(Packet packet, World world, int chunkX, int chunkZ) {
        PlayerManager playerManager = ((WorldServer)world).func_73040_p();
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!playerManager.func_72694_a(player, chunkX, chunkZ)) continue;
            PacketCustom.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    public void sendToOps() {
        PacketCustom.sendToOps((Packet)this.toPacket());
    }

    public static void sendToOps(Packet packet) {
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(player.func_70005_c_())) continue;
            PacketCustom.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketCustom.sendToServer((Packet)this.toPacket());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(Packet packet) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a(packet);
    }

    public static class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        public IHandshakeHandler handler;

        public HandshakeInboundHandler(IHandshakeHandler handler) {
            this.handler = handler;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof NetworkHandshakeEstablished) {
                INetHandler netHandler = ((NetworkDispatcher)ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).get()).getNetHandler();
                if (netHandler instanceof NetHandlerPlayServer) {
                    this.handler.handshakeRecieved((NetHandlerPlayServer)netHandler);
                }
            } else {
                ctx.fireUserEventTriggered(evt);
            }
        }
    }

    public static interface IHandshakeHandler {
        public void handshakeRecieved(NetHandlerPlayServer var1);
    }

    public static class ServerInboundHandler
    implements CustomHandler {
        private IServerPacketHandler handler;

        public ServerInboundHandler(ICustomPacketHandler handler) {
            this.handler = (IServerPacketHandler)handler;
        }

        @Override
        public void handle(INetHandler netHandler, String channel, PacketCustom packet) throws Exception {
            if (netHandler instanceof NetHandlerPlayServer) {
                this.handler.handlePacket(packet, ((NetHandlerPlayServer)netHandler).field_147369_b, (INetHandlerPlayServer)netHandler);
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    public static class ClientInboundHandler
    implements CustomHandler {
        private IClientPacketHandler handler;

        public ClientInboundHandler(ICustomPacketHandler handler) {
            this.handler = (IClientPacketHandler)handler;
        }

        @Override
        public void handle(INetHandler netHandler, String channel, PacketCustom packet) throws Exception {
            if (netHandler instanceof INetHandlerPlayClient) {
                this.handler.handlePacket(packet, Minecraft.func_71410_x(), (INetHandlerPlayClient)netHandler);
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    private static interface CustomHandler {
        public void handle(INetHandler var1, String var2, PacketCustom var3) throws Exception;
    }

    @ChannelHandler.Sharable
    public static class CustomInboundHandler
    extends SimpleChannelInboundHandler<FMLProxyPacket> {
        public EnumMap<Side, CustomHandler> handlers = Maps.newEnumMap(Side.class);

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            ctx.channel().attr(cclHandler).set((Object)this);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
            this.handlers.get(ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get()).handle((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get(), new PacketCustom(msg.payload()));
        }
    }

    public static interface IServerPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, EntityPlayerMP var2, INetHandlerPlayServer var3);
    }

    public static interface IClientPacketHandler
    extends ICustomPacketHandler {
        public void handlePacket(PacketCustom var1, Minecraft var2, INetHandlerPlayClient var3);
    }

    public static interface ICustomPacketHandler {
    }
}

