/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.google.common.base.Charsets;
import io.netty.handler.codec.EncoderException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MCDataIO {
    public static int readVarInt(MCDataInput in) {
        byte b0;
        int i = 0;
        int j = 0;
        do {
            b0 = in.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readVarShort(MCDataInput in) {
        int low = in.readUShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = in.readUByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static String readString(MCDataInput in) {
        return new String(in.readArray(in.readVarInt()), Charsets.UTF_8);
    }

    public static ItemStack readItemStack(MCDataInput in) {
        ItemStack item = null;
        short itemID = in.readShort();
        if (itemID >= 0) {
            int stackSize = in.readVarInt();
            short damage = in.readShort();
            item = new ItemStack(Item.func_150899_d((int)itemID), stackSize, (int)damage);
            item.func_77982_d(in.readNBTTagCompound());
        }
        return item;
    }

    public static FluidStack readFluidStack(MCDataInput in) {
        FluidStack fluid = null;
        short fluidID = in.readShort();
        if (fluidID >= 0) {
            fluid = new FluidStack((int)fluidID, in.readVarInt(), in.readNBTTagCompound());
        }
        return fluid;
    }

    public static void writeVarInt(MCDataOutput out, int i) {
        while ((i & 0x80) != 0) {
            out.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        out.writeByte(i);
    }

    public static void writeVarShort(MCDataOutput out, int s) {
        int low = s & Short.MAX_VALUE;
        int high = (s & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        out.writeShort(low);
        if (high != 0) {
            out.writeByte(high);
        }
    }

    public static void writeString(MCDataOutput out, String string) {
        byte[] abyte = string.getBytes(Charsets.UTF_8);
        if (abyte.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + string.length() + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        out.writeVarInt(abyte.length);
        out.writeArray(abyte);
    }

    public static void writeItemStack(MCDataOutput out, ItemStack stack) {
        if (stack == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            out.writeVarInt(stack.field_77994_a);
            out.writeShort(stack.func_77952_i());
            out.writeNBTTagCompound(stack.func_77973_b().func_77651_p() ? stack.func_77978_p() : null);
        }
    }

    public static void writeFluidStack(MCDataOutput out, FluidStack fluid) {
        if (fluid == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(fluid.fluidID);
            out.writeVarInt(fluid.amount);
            out.writeNBTTagCompound(fluid.tag);
        }
    }
}

