/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.lighting;

import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.BlockCoord;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = CCRenderState.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IBlockAccess access;
    public BlockCoord pos = new BlockCoord();
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IBlockAccess a, int x, int y, int z) {
        this.access = a;
        this.pos.set(x, y, z);
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        if ((this.sampled & 1 << side) == 0) {
            BlockPos bp = this.pos.pos();
            IBlockState b = this.access.func_180495_p(bp);
            this.brightness[side] = this.access.func_175626_b(bp, b.func_177230_c().getLightValue(this.access, bp));
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load() {
        CCRenderState.pipeline.addDependency(CCRenderState.sideAttrib);
        return true;
    }

    @Override
    public void operate() {
        super.operate();
        CCRenderState.setBrightness(this.brightness(CCRenderState.side));
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

