/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.IItemRenderer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelRegistryHelper {
    private static List<Pair<ResourceLocation, IBakedModel>> registerModels = new LinkedList<Pair<ResourceLocation, IBakedModel>>();

    public static void register(ResourceLocation location, IBakedModel model) {
        registerModels.add((Pair<ResourceLocation, IBakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    public static void registerItemModel(Item item, ResourceLocation location) {
        ModelRegistryHelper.registerItemModel(item, 0, location);
    }

    public static void registerItemModel(Item item, int meta, ResourceLocation location) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(location, "inventory"));
    }

    public static void registerItemMesher(Item item, ItemMeshDefinition mesher) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, mesher);
    }

    public static void registerItemRenderer(Item item, IItemRenderer renderer, ResourceLocation location) {
        final ModelResourceLocation modelLoc = new ModelResourceLocation(location, "inventory");
        ModelRegistryHelper.register((ResourceLocation)modelLoc, renderer);
        ModelRegistryHelper.registerItemMesher(item, new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return modelLoc;
            }
        });
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Pair<ResourceLocation, IBakedModel> pair : registerModels) {
            event.modelRegistry.func_82595_a(pair.getKey(), pair.getValue());
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new ModelRegistryHelper());
    }
}

