/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static EntityItem entityItem;

    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, TextureAtlasSprite icon, double res) {
        RenderUtils.renderFluidQuad(point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void renderFluidQuad(Vector3 base, Vector3 wide, Vector3 high, TextureAtlasSprite icon, double res) {
        double rx;
        WorldRenderer r = Tessellator.func_178181_a().func_178180_c();
        double u1 = icon.func_94209_e();
        double du = icon.func_94212_f() - icon.func_94209_e();
        double v2 = icon.func_94210_h();
        double dv = icon.func_94210_h() - icon.func_94206_g();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                r.func_178985_a(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                r.func_178985_a(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2);
                r.func_178985_a(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                r.func_178985_a(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        WorldRenderer r = CCRenderState.startDrawing(3);
        r.func_178984_b(c.min.x, c.min.y, c.min.z);
        r.func_178984_b(c.max.x, c.min.y, c.min.z);
        r.func_178984_b(c.max.x, c.min.y, c.max.z);
        r.func_178984_b(c.min.x, c.min.y, c.max.z);
        r.func_178984_b(c.min.x, c.min.y, c.min.z);
        CCRenderState.draw();
        CCRenderState.startDrawing(3);
        r.func_178984_b(c.min.x, c.max.y, c.min.z);
        r.func_178984_b(c.max.x, c.max.y, c.min.z);
        r.func_178984_b(c.max.x, c.max.y, c.max.z);
        r.func_178984_b(c.min.x, c.max.y, c.max.z);
        r.func_178984_b(c.min.x, c.max.y, c.min.z);
        CCRenderState.draw();
        CCRenderState.startDrawing(1);
        r.func_178984_b(c.min.x, c.min.y, c.min.z);
        r.func_178984_b(c.min.x, c.max.y, c.min.z);
        r.func_178984_b(c.max.x, c.min.y, c.min.z);
        r.func_178984_b(c.max.x, c.max.y, c.min.z);
        r.func_178984_b(c.max.x, c.min.y, c.max.z);
        r.func_178984_b(c.max.x, c.max.y, c.max.z);
        r.func_178984_b(c.min.x, c.min.y, c.max.z);
        r.func_178984_b(c.min.x, c.max.y, c.max.z);
        CCRenderState.draw();
    }

    public static void renderFluidCuboid(Cuboid6 bound, TextureAtlasSprite tex, double res) {
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        WorldRenderer r = Tessellator.func_178181_a().func_178180_c();
        switch (side) {
            case 0: {
                r.func_178985_a(points[0], points[2], points[4], tx1, ty1);
                r.func_178985_a(points[1], points[2], points[4], tx2, ty1);
                r.func_178985_a(points[1], points[2], points[5], tx2, ty2);
                r.func_178985_a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                r.func_178985_a(points[1], points[3], points[4], tx2, ty1);
                r.func_178985_a(points[0], points[3], points[4], tx1, ty1);
                r.func_178985_a(points[0], points[3], points[5], tx1, ty2);
                r.func_178985_a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                r.func_178985_a(points[0], points[3], points[4], tx2, ty1);
                r.func_178985_a(points[1], points[3], points[4], tx1, ty1);
                r.func_178985_a(points[1], points[2], points[4], tx1, ty2);
                r.func_178985_a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                r.func_178985_a(points[1], points[3], points[5], tx2, ty1);
                r.func_178985_a(points[0], points[3], points[5], tx1, ty1);
                r.func_178985_a(points[0], points[2], points[5], tx1, ty2);
                r.func_178985_a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                r.func_178985_a(points[0], points[3], points[5], tx2, ty1);
                r.func_178985_a(points[0], points[3], points[4], tx1, ty1);
                r.func_178985_a(points[0], points[2], points[4], tx1, ty2);
                r.func_178985_a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                r.func_178985_a(points[1], points[3], points[4], tx2, ty1);
                r.func_178985_a(points[1], points[3], points[5], tx1, ty1);
                r.func_178985_a(points[1], points[2], points[5], tx1, ty2);
                r.func_178985_a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.amount > 0 && stack.getFluid() != null;
    }

    public static TextureAtlasSprite prepareFluidRender(FluidStack stack, int alpha) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Fluid fluid = stack.getFluid();
        CCRenderState.setColour(fluid.getColor(stack) << 8 | alpha);
        CCRenderState.changeTexture(TextureMap.field_110575_b);
        String iconName = null;
        if (fluid == FluidRegistry.LAVA) {
            iconName = "minecraft:blocks/lava_still";
        } else if (fluid == FluidRegistry.WATER) {
            iconName = "minecraft:blocks/water_still";
        }
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(iconName);
    }

    public static void postFluidRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    public static double fluidDensityToAlpha(double density) {
        return Math.pow(density, 0.4);
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * density;
        }
        TextureAtlasSprite tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidCuboid(bound, tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            int height = (int)((double)rect.h * density);
            rect.y += rect.h - height;
            rect.h = height;
        }
        TextureAtlasSprite tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing();
        RenderUtils.renderFluidQuad(new Vector3(rect.x, rect.y + rect.h, 0.0), new Vector3(rect.w, 0.0, 0.0), new Vector3(0.0, -rect.h, 0.0), tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static boolean checkEnableStencil() {
        Framebuffer fb = Minecraft.func_71410_x().func_147110_a();
        return fb.isStencilEnabled() || fb.enableStencil();
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        entityItem = new EntityItem(null);
        RenderUtils.entityItem.field_70290_d = 0.0f;
    }
}

