/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.SpriteSheetManager;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureFX;
import codechicken.lib.render.TextureUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureSpecial
extends TextureAtlasSprite
implements TextureUtils.IIconRegister {
    private int spriteIndex;
    private SpriteSheetManager.SpriteSheet spriteSheet;
    private TextureFX textureFX;
    private int mipmapLevels;
    private int rawWidth;
    private int rawHeight;
    private int blankSize = -1;
    private ArrayList<TextureDataHolder> baseTextures;
    private boolean selfRegister;
    public int atlasIndex;

    protected TextureSpecial(String par1) {
        super(par1);
    }

    public TextureSpecial addTexture(TextureDataHolder t) {
        if (this.baseTextures == null) {
            this.baseTextures = new ArrayList();
        }
        this.baseTextures.add(t);
        return this;
    }

    public TextureSpecial baseFromSheet(SpriteSheetManager.SpriteSheet spriteSheet, int spriteIndex) {
        this.spriteSheet = spriteSheet;
        this.spriteIndex = spriteIndex;
        return this;
    }

    public TextureSpecial addTextureFX(TextureFX fx) {
        this.textureFX = fx;
        return this;
    }

    public void func_110971_a(int sheetWidth, int sheetHeight, int originX, int originY, boolean rotated) {
        super.func_110971_a(sheetWidth, sheetHeight, originX, originY, rotated);
        if (this.textureFX != null) {
            this.textureFX.onTextureDimensionsUpdate(this.rawWidth, this.rawHeight);
        }
    }

    public void func_94219_l() {
        if (this.textureFX != null) {
            this.textureFX.update();
            if (this.textureFX.changed()) {
                Object mipmaps = new int[this.mipmapLevels + 1][];
                mipmaps[0] = this.textureFX.imageData;
                mipmaps = TextureUtil.func_147949_a((int)this.mipmapLevels, (int)this.field_130223_c, (int[][])mipmaps);
                TextureUtil.func_147955_a((int[][])mipmaps, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }

    public void func_180598_a(BufferedImage[] images, AnimationMetadataSection animationMeta) {
        this.rawWidth = images[0].getWidth();
        this.rawHeight = images[0].getHeight();
        super.func_180598_a(images, animationMeta);
    }

    public void func_147963_d(int p_147963_1_) {
        super.func_147963_d(p_147963_1_);
        this.mipmapLevels = p_147963_1_;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public void addFrame(int[] data, int width, int height) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        BufferedImage[] images = new BufferedImage[settings.field_151442_I + 1];
        images[0] = new BufferedImage(width, height, 2);
        images[0].setRGB(0, 0, width, height, data, 0, width);
        this.func_180598_a(images, null);
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        if (this.baseTextures != null) {
            for (TextureDataHolder tex : this.baseTextures) {
                this.addFrame(tex.data, tex.width, tex.height);
            }
        } else if (this.spriteSheet != null) {
            TextureDataHolder tex = this.spriteSheet.createSprite(this.spriteIndex);
            this.addFrame(tex.data, tex.width, tex.height);
        } else if (this.blankSize > 0) {
            this.addFrame(new int[this.blankSize * this.blankSize], this.blankSize, this.blankSize);
        }
        if (this.field_110976_a.isEmpty()) {
            throw new RuntimeException("No base frame for texture: " + this.func_94215_i());
        }
        return false;
    }

    public boolean func_130098_m() {
        return this.textureFX != null || super.func_130098_m();
    }

    public int func_110970_k() {
        if (this.textureFX != null) {
            return 1;
        }
        return super.func_110970_k();
    }

    public TextureSpecial blank(int size) {
        this.blankSize = size;
        return this;
    }

    public TextureSpecial selfRegister() {
        this.selfRegister = true;
        TextureUtils.addIconRegister(this);
        return this;
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        textureMap.setTextureEntry(this.func_94215_i(), (TextureAtlasSprite)this);
    }
}

