/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.PlaceholderTexture;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureSpecial;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static ArrayList<IIconRegister> iconRegisters;

    public static void addIconRegister(IIconRegister registrar) {
        iconRegisters.add(registrar);
    }

    @SubscribeEvent
    public void textureLoad(TextureStitchEvent.Pre event) {
        for (IIconRegister reg : iconRegisters) {
            reg.registerIcons(event.map);
        }
    }

    public static int[] loadTextureData(ResourceLocation resource) {
        return TextureUtils.loadTexture((ResourceLocation)resource).data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static InputStream getTextureResource(ResourceLocation textureFile) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(textureFile).func_110527_b();
    }

    public static BufferedImage loadBufferedImage(ResourceLocation textureFile) {
        try {
            return TextureUtils.loadBufferedImage(TextureUtils.getTextureResource(textureFile));
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static TextureAtlasSprite getBlankIcon(int size, TextureMap textureMap) {
        String s = "blank_" + size;
        TextureAtlasSprite icon = textureMap.getTextureExtry(s);
        if (icon == null) {
            icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, icon);
        }
        return icon;
    }

    public static TextureSpecial getTextureSpecial(TextureMap textureMap, String name) {
        if (textureMap.getTextureExtry(name) != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (TextureAtlasSprite)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        if (target == 3553) {
            GlStateManager.func_179144_i((int)target);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureDataHolder loadTexture(ResourceLocation resource) {
        BufferedImage img = TextureUtils.loadBufferedImage(resource);
        if (img == null) {
            throw new RuntimeException("Texture not found: " + resource);
        }
        return new TextureDataHolder(img);
    }

    public static boolean refreshTexture(TextureMap map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (TextureAtlasSprite)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        iconRegisters = new ArrayList();
    }

    public static interface IIconRegister {
        public void registerIcons(TextureMap var1);
    }
}

