/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.BakedModelProperties;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class PerspectiveAwareLayeredModel
implements IPerspectiveAwareModel {
    private final ImmutableMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap;
    private final ImmutableMap<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads;
    private final IModelState state;
    private final BakedModelProperties properties;

    public PerspectiveAwareLayeredModel(Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap, IModelState state, BakedModelProperties properties) {
        this(layerFaceQuadMap, (Map<BlockRenderLayer, List<BakedQuad>>)ImmutableMap.of(), state, properties);
    }

    public PerspectiveAwareLayeredModel(Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap, Map<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads, IModelState state, BakedModelProperties properties) {
        this.layerFaceQuadMap = ImmutableMap.copyOf(layerFaceQuadMap);
        this.layerGeneralQuads = ImmutableMap.copyOf(layerGeneralQuads);
        this.state = state;
        this.properties = properties.copy();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        Map faceQuadMap;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            layer = BlockRenderLayer.SOLID;
        }
        if (side == null) {
            if (this.layerGeneralQuads.containsKey((Object)layer)) {
                return (List)this.layerGeneralQuads.get((Object)layer);
            }
        } else if (this.layerFaceQuadMap.containsKey((Object)layer) && (faceQuadMap = (Map)this.layerFaceQuadMap.get((Object)layer)).containsKey(side)) {
            return (List)faceQuadMap.get(side);
        }
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.properties.isGui3d();
    }

    public boolean func_188618_c() {
        return this.properties.isBuiltInRenderer();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.properties.getParticleTexture();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

