/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm;

import codechicken.lib.asm.ObfMapping;
import java.io.File;
import java.io.PrintWriter;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceMethodVisitor;

public class MethodASMifier
extends ClassVisitor {
    PrintWriter printWriter;
    ObfMapping method;
    Printer asmifier;

    public MethodASMifier(ObfMapping method, Printer printer, PrintWriter printWriter) {
        super(262144);
        this.method = method;
        this.printWriter = printWriter;
        this.asmifier = printer;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.method.matches(name, desc)) {
            Printer localPrinter = this.asmifier.visitMethod(access, name, desc, signature, exceptions);
            return new TraceMethodVisitor(null, localPrinter);
        }
        return null;
    }

    public void visitEnd() {
        this.asmifier.visitClassEnd();
        this.asmifier.print(this.printWriter);
        super.visitEnd();
    }

    public static void printMethod(ObfMapping method, Printer printer, File toFile) {
        try {
            MethodASMifier.printMethod(method, Launch.classLoader.getClassBytes(method.javaClass()), printer, toFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printMethod(ObfMapping method, byte[] bytes, Printer printer, File toFile) {
        try {
            if (!toFile.getParentFile().exists()) {
                toFile.getParentFile().mkdirs();
            }
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter(toFile);
            MethodASMifier cv = new MethodASMifier(method, printer, printWriter);
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cv, 0);
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

