/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.blockstate;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;

public class CCFinalVariant
extends Variant {
    private final IModelState state;
    private final boolean smooth;
    private final boolean gui3d;
    private final ImmutableMap<String, String> customData;
    private final ImmutableMap<String, String> textures;

    public CCFinalVariant(ResourceLocation model, IModelState state, boolean uvLock, boolean smooth, boolean gui3d, int weight, Map<String, String> textures, String textureDomain, Map<String, String> customData) {
        super(model == null ? new ResourceLocation("builtin/missing") : model, state instanceof ModelRotation ? (ModelRotation)state : ModelRotation.X0_Y0, uvLock, weight);
        this.state = state;
        this.smooth = smooth;
        this.gui3d = gui3d;
        HashMap<String, String> newTextures = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : textures.entrySet()) {
            String prefixedTexture = entry.getValue();
            if (!entry.getValue().contains(":")) {
                prefixedTexture = textureDomain + ":" + prefixedTexture;
            }
            newTextures.put(entry.getKey(), prefixedTexture);
        }
        this.textures = ImmutableMap.copyOf(newTextures);
        this.customData = ImmutableMap.copyOf(customData);
    }

    public static IModel runModelHooks(IModel base, boolean smooth, boolean gui3d, boolean uvlock, ImmutableMap<String, String> textureMap, ImmutableMap<String, String> customData) {
        base = ModelProcessingHelper.customData((IModel)base, customData);
        base = ModelProcessingHelper.retexture((IModel)base, textureMap);
        base = ModelProcessingHelper.smoothLighting((IModel)base, (boolean)smooth);
        base = ModelProcessingHelper.gui3d((IModel)base, (boolean)gui3d);
        base = ModelProcessingHelper.uvlock((IModel)base, (boolean)uvlock);
        return base;
    }

    public IModel process(IModel base) {
        boolean hasBase;
        boolean bl = hasBase = base != ModelLoaderRegistry.getMissingModel();
        if (hasBase) {
            base = CCFinalVariant.runModelHooks(base, this.smooth, this.gui3d, this.func_188049_c(), this.textures, this.customData);
        }
        return base;
    }

    public IModelState getState() {
        return this.state;
    }
}

