/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.modelbase;

import codechicken.lib.model.modelbase.CCModelBase;
import codechicken.lib.model.modelbase.CCModelBox;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCQuad;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.VertexBuffer;

public class CCModelRenderer {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    private CCModel compiledModel;
    public boolean compiled;
    public List<CCModelBox> cubeList = Lists.newArrayList();
    public List<CCModelRenderer> childModels;
    public final String boxName;
    private final CCModelBase baseModel;
    public float offsetX;
    public float offsetY;
    public float offsetZ;

    public CCModelRenderer(CCModelBase model, String boxNameIn) {
        this.baseModel = model;
        model.boxList.add(this);
        this.boxName = boxNameIn;
        this.setTextureSize(model.textureWidth, model.textureHeight);
    }

    public CCModelRenderer(CCModelBase model) {
        this(model, null);
    }

    public CCModelRenderer(CCModelBase model, int texOffX, int texOffY) {
        this(model);
        this.setTextureOffset(texOffX, texOffY);
    }

    public void addChild(CCModelRenderer renderer) {
        if (this.childModels == null) {
            this.childModels = Lists.newArrayList();
        }
        this.childModels.add(renderer);
    }

    public CCModelRenderer setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public CCModelRenderer addBox(String partName, float offX, float offY, float offZ, int width, int height, int depth) {
        partName = this.boxName + "." + partName;
        UV textureOffset = this.baseModel.getTextureOffset(partName);
        this.setTextureOffset((int)textureOffset.u, (int)textureOffset.v);
        this.cubeList.add(new CCModelBox(this, this.textureOffsetX, this.textureOffsetY, offX, offY, offZ, width, height, depth, 0.0f).setBoxName(partName));
        return this;
    }

    public CCModelRenderer addBox(float offX, float offY, float offZ, int width, int height, int depth) {
        this.cubeList.add(new CCModelBox(this, this.textureOffsetX, this.textureOffsetY, offX, offY, offZ, width, height, depth, 0.0f));
        return this;
    }

    public CCModelRenderer addBox(float offX, float offY, float offZ, int width, int height, int depth, boolean mirrored) {
        this.cubeList.add(new CCModelBox(this, this.textureOffsetX, this.textureOffsetY, offX, offY, offZ, width, height, depth, 0.0f, mirrored));
        return this;
    }

    public void addBox(float offX, float offY, float offZ, int width, int height, int depth, float scaleFactor) {
        this.cubeList.add(new CCModelBox(this, this.textureOffsetX, this.textureOffsetY, offX, offY, offZ, width, height, depth, scaleFactor));
    }

    public void setRotationPoint(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.rotationPointX = rotationPointXIn;
        this.rotationPointY = rotationPointYIn;
        this.rotationPointZ = rotationPointZIn;
    }

    public void render(float scale, VertexBuffer buffer) {
    }

    public CCModel bake(float scale) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileModel(scale);
            }
            LinkedList<Transformation> transforms = new LinkedList<Transformation>();
            LinkedList<CCModel> finalModelElements = new LinkedList<CCModel>();
            transforms.add(new Translation(this.offsetX, this.offsetY, this.offsetZ));
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    finalModelElements.add(this.compiledModel.copy());
                    if (this.childModels != null) {
                        for (CCModelRenderer modelRenderer : this.childModels) {
                            finalModelElements.add(modelRenderer.bake(scale).copy());
                        }
                    }
                } else {
                    transforms.add(new Translation(this.rotationPointX * scale, this.rotationPointY * scale, this.rotationPointZ * scale));
                    finalModelElements.add(this.compiledModel.copy());
                    if (this.childModels != null) {
                        for (CCModelRenderer modelRenderer : this.childModels) {
                            finalModelElements.add(modelRenderer.bake(scale).copy());
                        }
                    }
                }
            } else {
                transforms.add(new Translation(this.rotationPointX * scale, this.rotationPointY * scale, this.rotationPointZ * scale));
                if (this.rotateAngleZ != 0.0f) {
                    transforms.add(new Rotation(this.rotateAngleZ, new Vector3(0.0, 0.0, 1.0).normalize()));
                }
                if (this.rotateAngleY != 0.0f) {
                    transforms.add(new Rotation(this.rotateAngleY, new Vector3(0.0, 1.0, 0.0).normalize()));
                }
                if (this.rotateAngleX != 0.0f) {
                    transforms.add(new Rotation(this.rotateAngleZ, new Vector3(1.0, 0.0, 0.0).normalize()));
                }
                finalModelElements.add(this.compiledModel.copy());
                if (this.childModels != null) {
                    for (CCModelRenderer modelRenderer : this.childModels) {
                        finalModelElements.add(modelRenderer.bake(scale).copy());
                    }
                }
            }
            return CCModel.combine(finalModelElements).apply(new TransformationList(transforms.toArray(new Transformation[transforms.size()])));
        }
        return CCModel.newModel(7);
    }

    private CCModel compileModel(float scale) {
        if (this.compiled) {
            return this.compiledModel;
        }
        CCModel model = CCModel.newModel(7);
        LinkedList vertices = new LinkedList();
        for (CCModelBox box : this.cubeList) {
            for (CCQuad quad : box.getQuads()) {
                Collections.addAll(vertices, quad.vertices);
            }
        }
        model.verts = vertices.toArray(new Vertex5[vertices.size()]);
        model.computeNormals();
        this.compiledModel = model.copy().apply(new Scale(scale));
        this.compiled = true;
        return this.compiledModel;
    }

    public CCModelRenderer setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }
}

