/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import codechicken.lib.render.particle.DigIconParticle;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CustomParticleHandler {
    public static void addHitEffects(IBlockState state, World world, RayTraceResult trace, ParticleManager particleManager, IWorldBlockTextureProvider provider) {
        TextureAtlasSprite sprite = provider.getTexture(trace.field_178784_b, state, BlockRenderLayer.SOLID, (IBlockAccess)world, trace.func_178782_a());
        Cuboid6 cuboid = new Cuboid6(state.func_185900_c((IBlockAccess)world, trace.func_178782_a())).add(trace.func_178782_a());
        CustomParticleHandler.addBlockHitEffects(world, cuboid, trace.field_178784_b, sprite, particleManager);
    }

    public static void addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager, IWorldBlockTextureProvider provider) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
        IBlockState state = world.func_180495_p(pos);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            sprites[face.ordinal()] = provider.getTexture(face, state, BlockRenderLayer.SOLID, (IBlockAccess)world, pos);
        }
        Cuboid6 cuboid = new Cuboid6(state.func_185900_c((IBlockAccess)world, pos)).add(pos);
        CustomParticleHandler.addBlockDestroyEffects(world, cuboid, sprites, particleManager);
    }

    public static void addBlockHitEffects(World world, Cuboid6 bounds, EnumFacing side, TextureAtlasSprite icon, ParticleManager particleManager) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.field_73012_v.nextDouble();
        diff.y *= world.field_73012_v.nextDouble();
        diff.z *= world.field_73012_v.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == EnumFacing.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == EnumFacing.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == EnumFacing.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == EnumFacing.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == EnumFacing.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == EnumFacing.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        particleManager.func_78873_a(new DigIconParticle(world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, TextureAtlasSprite[] icons, ParticleManager particleManager) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).celi();
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    particleManager.func_78873_a((Particle)new DigIconParticle(world, x, y, z, x - center.x, y - center.y, z - center.z, icons[world.field_73012_v.nextInt(icons.length)]));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

