/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.network;

import codechicken.lib.inventory.container.ICCLContainerType;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.vec.Vector3;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    @Override
    public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                BlockPos pos = packet.readPos();
                Vector3 vec = packet.readVector();
                int numParticles = packet.readVarInt();
                BlockState state = mc.field_71441_e.func_180495_p(pos);
                CustomParticleHandler.addLandingEffects((World)mc.field_71441_e, pos, state, vec, numParticles);
                break;
            }
            case 10: {
                this.handleOpenContainer(packet, mc);
            }
        }
    }

    private void handleOpenContainer(PacketCustom packet, Minecraft mc) {
        ContainerType rawType = (ContainerType)packet.readRegistryIdUnsafe(ForgeRegistries.CONTAINERS);
        int windowId = packet.readVarInt();
        ITextComponent name = packet.readTextComponent();
        if (rawType instanceof ICCLContainerType) {
            ICCLContainerType type = (ICCLContainerType)rawType;
            ScreenManager.getScreenFactory((ContainerType)rawType, (Minecraft)mc, (int)windowId, (ITextComponent)name).map(e -> e).ifPresent(screenFactory -> {
                Object container = type.create(windowId, Minecraft.func_71410_x().field_71439_g.field_71071_by, packet);
                Screen screen = screenFactory.create(container, mc.field_71439_g.field_71071_by, name);
                mc.field_71439_g.field_71070_bA = ((IHasContainer)screen).func_212873_a_();
                mc.func_147108_a(screen);
            });
        }
    }
}

