/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.vec.Cuboid6;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.apache.commons.lang3.tuple.MutablePair;

public class VoxelShapeCache {
    private static final Cache<AxisAlignedBB, VoxelShape> bbToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<Cuboid6, VoxelShape> cuboidToShapeCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();
    private static final Cache<VoxelShape, MutablePair<AxisAlignedBB, Cuboid6>> shapeToBBCuboid = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).weakKeys().build();

    public static VoxelShape getShape(AxisAlignedBB aabb) {
        VoxelShape shape = (VoxelShape)bbToShapeCache.getIfPresent((Object)aabb);
        if (shape == null) {
            shape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
            bbToShapeCache.put((Object)aabb, (Object)shape);
            MutablePair<AxisAlignedBB, Cuboid6> entry = VoxelShapeCache.getReverse(shape);
            if (entry.getLeft() == null) {
                entry.setLeft((Object)aabb);
            }
        }
        return shape;
    }

    public static VoxelShape getShape(Cuboid6 cuboid) {
        VoxelShape shape = (VoxelShape)cuboidToShapeCache.getIfPresent((Object)cuboid);
        if (shape == null) {
            shape = VoxelShapes.func_197873_a((double)cuboid.min.x, (double)cuboid.min.y, (double)cuboid.min.z, (double)cuboid.max.x, (double)cuboid.max.y, (double)cuboid.max.z);
            cuboidToShapeCache.put((Object)cuboid, (Object)shape);
            MutablePair<AxisAlignedBB, Cuboid6> entry = VoxelShapeCache.getReverse(shape);
            if (entry.getRight() == null) {
                entry.setRight((Object)cuboid);
            }
        }
        return shape;
    }

    public static AxisAlignedBB getAABB(VoxelShape shape) {
        MutablePair<AxisAlignedBB, Cuboid6> entry = VoxelShapeCache.getReverse(shape);
        if (entry.getLeft() == null) {
            entry.setLeft((Object)shape.func_197752_a());
        }
        return (AxisAlignedBB)entry.getLeft();
    }

    public static Cuboid6 getCuboid(VoxelShape shape) {
        MutablePair<AxisAlignedBB, Cuboid6> entry = VoxelShapeCache.getReverse(shape);
        if (entry.getRight() == null) {
            entry.setRight((Object)new Cuboid6(shape.func_197762_b(Direction.Axis.X), shape.func_197762_b(Direction.Axis.Y), shape.func_197762_b(Direction.Axis.Z), shape.func_197758_c(Direction.Axis.X), shape.func_197758_c(Direction.Axis.Y), shape.func_197758_c(Direction.Axis.Z)));
        }
        return (Cuboid6)entry.getRight();
    }

    private static MutablePair<AxisAlignedBB, Cuboid6> getReverse(VoxelShape shape) {
        MutablePair entry = (MutablePair)shapeToBBCuboid.getIfPresent((Object)shape);
        if (entry == null) {
            entry = new MutablePair();
            shapeToBBCuboid.put((Object)shape, (Object)entry);
        }
        return entry;
    }
}

