/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.Quad;
import codechicken.lib.render.buffer.ISpriteAwareVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class BakedQuadVertexBuilder
implements IVertexBuilder,
ISpriteAwareVertexBuilder {
    private final List<Quad> quadList = new ArrayList<Quad>();
    private final int glMode;
    private final int vSize;
    private Quad current;
    private int vertex;

    public BakedQuadVertexBuilder() {
        this(7);
    }

    public BakedQuadVertexBuilder(int glMode) {
        if (glMode != 7 && glMode != 4) {
            throw new IllegalArgumentException("Only GL_QUADS and GL_TRIANGLES supported. Got: " + glMode);
        }
        this.glMode = glMode;
        this.vSize = glMode == 7 ? 4 : 3;
    }

    public void reset() {
        this.quadList.clear();
        this.current = null;
        this.vertex = 0;
    }

    @Override
    public void sprite(TextureAtlasSprite sprite) {
        this.checkNewQuad();
        this.current.setTexture(sprite);
    }

    public IVertexBuilder func_225582_a_(double x, double y, double z) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].vec[0] = (float)x;
        this.current.vertices[this.vertex].vec[1] = (float)y;
        this.current.vertices[this.vertex].vec[2] = (float)z;
        return this;
    }

    public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].color[0] = (float)red / 255.0f;
        this.current.vertices[this.vertex].color[1] = (float)green / 255.0f;
        this.current.vertices[this.vertex].color[2] = (float)blue / 255.0f;
        this.current.vertices[this.vertex].color[3] = (float)alpha / 255.0f;
        return this;
    }

    public IVertexBuilder func_225583_a_(float u, float v) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].uv[0] = u;
        this.current.vertices[this.vertex].uv[1] = v;
        return this;
    }

    public IVertexBuilder func_225585_a_(int u, int v) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].overlay[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].overlay[1] = (float)v / 240.0f;
        return this;
    }

    public IVertexBuilder func_225587_b_(int u, int v) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].lightmap[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].lightmap[1] = (float)v / 240.0f;
        return this;
    }

    public IVertexBuilder func_225584_a_(float x, float y, float z) {
        this.checkNewQuad();
        this.current.vertices[this.vertex].normal[0] = x;
        this.current.vertices[this.vertex].normal[1] = y;
        this.current.vertices[this.vertex].normal[2] = z;
        return this;
    }

    public void func_181675_d() {
        ++this.vertex;
        if (this.vertex == this.vSize) {
            if (this.glMode == 4) {
                for (int e = 0; e < this.current.format.elementCount; ++e) {
                    System.arraycopy(this.current.vertices[2].raw[e], 0, this.current.vertices[3].raw[e], 0, 4);
                }
            }
            if (this.current.sprite == null) {
                throw new IllegalStateException("Sprite not set.");
            }
            this.quadList.add(this.current);
            this.current = null;
            this.vertex = 0;
        }
    }

    public List<BakedQuad> bake() {
        if (this.current != null) {
            throw new IllegalStateException("Not finished building.");
        }
        return this.quadList.stream().map(Quad::bake).collect(Collectors.toList());
    }

    private void checkNewQuad() {
        if (this.current == null) {
            this.current = new Quad(CachedFormat.lookup(DefaultVertexFormats.field_176600_a));
        }
    }
}

