/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataHandler;
import codechicken.lib.data.MCDataIO;
import codechicken.lib.vec.BlockCoord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class MCDataNBTWrapper
implements MCDataHandler {
    private NBTTagCompound tagCompound = new NBTTagCompound();
    private int readIndex = 0;
    private int writeIndex = 0;

    public MCDataNBTWrapper() {
    }

    public MCDataNBTWrapper(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    private void nextReadIndex() {
        ++this.readIndex;
    }

    private String getReadIndex() {
        return String.valueOf(this.readIndex);
    }

    private void nextWriteIndex() {
        ++this.writeIndex;
    }

    private String getWriteIndex() {
        return String.valueOf(this.writeIndex);
    }

    public NBTTagCompound build() {
        return this.tagCompound;
    }

    @Override
    public long readLong() {
        long l = this.tagCompound.func_74763_f(this.getReadIndex());
        this.nextReadIndex();
        return l;
    }

    @Override
    public int readInt() {
        int i = this.tagCompound.func_74762_e(this.getReadIndex());
        this.nextReadIndex();
        return i;
    }

    @Override
    public short readShort() {
        short s = this.tagCompound.func_74765_d(this.getReadIndex());
        this.nextReadIndex();
        return s;
    }

    @Override
    public int readUShort() {
        short s = this.tagCompound.func_74765_d(this.getReadIndex());
        this.nextReadIndex();
        return s;
    }

    @Override
    public byte readByte() {
        byte b = this.tagCompound.func_74771_c(this.getReadIndex());
        this.nextReadIndex();
        return b;
    }

    @Override
    public short readUByte() {
        byte b = this.tagCompound.func_74771_c(this.getReadIndex());
        this.nextReadIndex();
        return b;
    }

    @Override
    public double readDouble() {
        double d = this.tagCompound.func_74769_h(this.getReadIndex());
        this.nextReadIndex();
        return d;
    }

    @Override
    public float readFloat() {
        float f = this.tagCompound.func_74760_g(this.getReadIndex());
        this.nextReadIndex();
        return f;
    }

    @Override
    public boolean readBoolean() {
        boolean b = this.tagCompound.func_74767_n(this.getReadIndex());
        this.nextReadIndex();
        return b;
    }

    @Override
    public char readChar() {
        char c = this.tagCompound.func_74779_i(this.getReadIndex()).charAt(0);
        this.nextReadIndex();
        return c;
    }

    @Override
    public int readVarShort() {
        return MCDataIO.readVarShort(this);
    }

    @Override
    public int readVarInt() {
        return MCDataIO.readVarInt(this);
    }

    @Override
    public long readVarLong() {
        byte b0;
        long i = 0L;
        int j = 0;
        do {
            b0 = this.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    @Override
    public byte[] readArray(int length) {
        byte[] b = this.tagCompound.func_74770_j(this.getReadIndex());
        this.nextReadIndex();
        return b;
    }

    @Override
    public String readString() {
        String s = this.tagCompound.func_74779_i(this.getReadIndex());
        this.nextReadIndex();
        return s;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readPos());
    }

    @Override
    public BlockPos readPos() {
        return new BlockPos(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public NBTTagCompound readNBTTagCompound() {
        NBTTagCompound tag = this.tagCompound.func_74775_l(this.getReadIndex());
        this.nextReadIndex();
        return tag;
    }

    @Override
    public ItemStack readItemStack() {
        return MCDataIO.readItemStack(this);
    }

    @Override
    public FluidStack readFluidStack() {
        return MCDataIO.readFluidStack(this);
    }

    @Override
    public MCDataNBTWrapper writeLong(long l) {
        this.tagCompound.func_74772_a(this.getWriteIndex(), l);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeInt(int i) {
        this.tagCompound.func_74768_a(this.getWriteIndex(), i);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeShort(int s) {
        this.tagCompound.func_74777_a(this.getWriteIndex(), (short)s);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeByte(int b) {
        this.tagCompound.func_74774_a(this.getWriteIndex(), (byte)b);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeDouble(double d) {
        this.tagCompound.func_74780_a(this.getWriteIndex(), d);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeFloat(float f) {
        this.tagCompound.func_74776_a(this.getWriteIndex(), f);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeBoolean(boolean b) {
        this.tagCompound.func_74757_a(this.getWriteIndex(), b);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeChar(char c) {
        this.tagCompound.func_74778_a(this.getWriteIndex(), String.valueOf(c));
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeVarInt(int i) {
        MCDataIO.writeVarInt(this, i);
        return this;
    }

    @Override
    public MCDataNBTWrapper writeVarShort(int s) {
        MCDataIO.writeVarShort(this, s);
        return this;
    }

    @Override
    public MCDataNBTWrapper writeArray(byte[] array) {
        this.tagCompound.func_74773_a(this.getWriteIndex(), array);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeString(String s) {
        this.tagCompound.func_74778_a(this.getWriteIndex(), s);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public MCDataNBTWrapper writePos(BlockPos pos) {
        this.writeInt(pos.func_177958_n());
        this.writeInt(pos.func_177956_o());
        this.writeInt(pos.func_177952_p());
        return this;
    }

    @Override
    public MCDataNBTWrapper writeCoord(BlockCoord coord) {
        this.writePos(coord.pos());
        return this;
    }

    @Override
    public MCDataNBTWrapper writeNBTTagCompound(NBTTagCompound tag) {
        this.tagCompound.func_74782_a(this.getWriteIndex(), (NBTBase)tag);
        this.nextWriteIndex();
        return this;
    }

    @Override
    public MCDataNBTWrapper writeItemStack(ItemStack stack) {
        MCDataIO.writeItemStack(this, stack);
        return this;
    }

    @Override
    public MCDataNBTWrapper writeFluidStack(FluidStack liquid) {
        MCDataIO.writeFluidStack(this, liquid);
        return this;
    }
}

