/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.vec.Vector3;
import com.google.common.base.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;

public class InventoryUtils {
    public static ItemStack newItemStack(Item item, int size, int damage, NBTTagCompound tag) {
        ItemStack stack = new ItemStack(item, size, damage);
        stack.func_77982_d(tag);
        return stack;
    }

    public static int actualDamage(ItemStack stack) {
        return Items.field_151045_i.getDamage(stack);
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int size) {
        ItemStack item = inv.func_70301_a(slot);
        if (item != null) {
            if (item.field_77994_a <= size) {
                inv.func_70299_a(slot, null);
                inv.func_70296_d();
                return item;
            }
            ItemStack itemstack1 = item.func_77979_a(size);
            if (item.field_77994_a == 0) {
                inv.func_70299_a(slot, null);
            } else {
                inv.func_70299_a(slot, item);
            }
            inv.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public static ItemStack removeStackFromSlot(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        inv.func_70299_a(slot, null);
        return stack;
    }

    public static int incrStackSize(ItemStack base, ItemStack addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.field_77994_a);
        }
        return 0;
    }

    public static int incrStackSize(ItemStack base, int addition) {
        int totalSize = base.field_77994_a + addition;
        if (totalSize <= base.func_77976_d()) {
            return addition;
        }
        if (base.field_77994_a < base.func_77976_d()) {
            return base.func_77976_d() - base.field_77994_a;
        }
        return 0;
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", items[i].field_77994_a);
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)items[i].field_77994_a);
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!tag.func_74764_b("Quantity")) continue;
            items[b].field_77994_a = ((NBTBase.NBTPrimitive)tag.func_74781_a("Quantity")).func_150287_d();
        }
    }

    public static void dropItem(ItemStack stack, World world, Vector3 dropLocation) {
        EntityItem item = new EntityItem(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
        item.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + (double)0.2f;
        item.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
        world.func_72838_d((Entity)item);
    }

    public static ItemStack copyStack(ItemStack stack, int quantity) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = quantity;
        return stack;
    }

    public static int getInsertibleQuantity(InventoryRange inv, ItemStack stack) {
        int quantity = 0;
        stack = InventoryUtils.copyStack(stack, Integer.MAX_VALUE);
        for (int slot : inv.slots) {
            quantity += InventoryUtils.fitStackInSlot(inv, slot, stack);
        }
        return quantity;
    }

    public static int getInsertibleQuantity(IInventory inv, ItemStack stack) {
        return InventoryUtils.getInsertibleQuantity(new InventoryRange(inv), stack);
    }

    public static int fitStackInSlot(InventoryRange inv, int slot, ItemStack stack) {
        ItemStack base = inv.inv.func_70301_a(slot);
        if (!InventoryUtils.canStack(base, stack) || !inv.canInsertItem(slot, stack)) {
            return 0;
        }
        int fit = base != null ? InventoryUtils.incrStackSize(base, inv.inv.func_70297_j_() - base.field_77994_a) : inv.inv.func_70297_j_();
        return Math.min(fit, stack.field_77994_a);
    }

    public static int fitStackInSlot(IInventory inv, int slot, ItemStack stack) {
        return InventoryUtils.fitStackInSlot(new InventoryRange(inv), slot, stack);
    }

    public static int insertItem(InventoryRange inv, ItemStack stack, boolean simulate) {
        stack = stack.func_77946_l();
        for (int pass = 0; pass < 2; ++pass) {
            int[] arr$ = inv.slots;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int fit;
                int slot;
                ItemStack base;
                if (pass == 0 == ((base = inv.inv.func_70301_a(slot = arr$[i$])) == null) || (fit = InventoryUtils.fitStackInSlot(inv, slot, stack)) == 0) continue;
                if (base != null) {
                    stack.field_77994_a -= fit;
                    if (!simulate) {
                        base.field_77994_a += fit;
                        inv.inv.func_70299_a(slot, base);
                    }
                } else {
                    if (!simulate) {
                        inv.inv.func_70299_a(slot, InventoryUtils.copyStack(stack, fit));
                    }
                    stack.field_77994_a -= fit;
                }
                if (stack.field_77994_a != 0) continue;
                return 0;
            }
        }
        return stack.field_77994_a;
    }

    public static int insertItem(IInventory inv, ItemStack stack, boolean simulate) {
        return InventoryUtils.insertItem(new InventoryRange(inv), stack, simulate);
    }

    public static ItemStack getExtractableStack(InventoryRange inv, int slot) {
        ItemStack stack = inv.inv.func_70301_a(slot);
        if (stack == null || !inv.canExtractItem(slot, stack)) {
            return null;
        }
        return stack;
    }

    public static ItemStack getExtractableStack(IInventory inv, int slot) {
        return InventoryUtils.getExtractableStack(new InventoryRange(inv), slot);
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && stack1.field_77994_a == stack2.field_77994_a && Objects.equal((Object)stack1.func_77978_p(), (Object)stack2.func_77978_p());
    }

    public static IInventory getInventory(World world, BlockPos pos) {
        return InventoryUtils.getInventory(world.func_175625_s(pos));
    }

    public static IInventory getInventory(TileEntity tile) {
        if (!(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            return InventoryUtils.getChest((TileEntityChest)tile);
        }
        return (IInventory)tile;
    }

    public static IInventory getChest(TileEntityChest chest) {
        for (EnumFacing fside : EnumFacing.Plane.HORIZONTAL) {
            if (chest.func_145831_w().func_180495_p(chest.func_174877_v().func_177972_a(fside)).func_177230_c() != chest.func_145838_q()) continue;
            return new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityChest)chest.func_145831_w().func_175625_s(chest.func_174877_v().func_177972_a(fside))), (ILockableContainer)chest);
        }
        return chest;
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77952_i() == stack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }

    public static void consumeItem(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        Item item = stack.func_77973_b();
        if (item.hasContainerItem(stack)) {
            ItemStack container = item.getContainerItem(stack);
            inv.func_70299_a(slot, container);
        } else {
            inv.func_70298_a(slot, 1);
        }
    }

    public static int stackSize(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        return stack == null ? 0 : stack.field_77994_a;
    }

    public static void dropOnClose(EntityPlayer player, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70304_b(i);
            if (stack == null) continue;
            player.func_71019_a(stack, false);
        }
    }

    public static NBTTagCompound savePersistant(ItemStack stack, NBTTagCompound tag) {
        stack.func_77955_b(tag);
        tag.func_82580_o("id");
        tag.func_74778_a("name", stack.func_77973_b().getRegistryName().toString());
        return tag;
    }

    public static ItemStack loadPersistant(NBTTagCompound tag) {
        String name = tag.func_74779_i("name");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        if (item == null) {
            return null;
        }
        byte count = tag.func_74764_b("Count") ? tag.func_74771_c("Count") : (byte)1;
        short damage = tag.func_74764_b("Damage") ? tag.func_74765_d("Damage") : (short)0;
        ItemStack stack = new ItemStack(item, (int)count, (int)damage);
        if (tag.func_150297_b("tag", 10)) {
            stack.func_77982_d(tag.func_74775_l("tag"));
        }
        return stack;
    }
}

