/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.lighting.LC;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.UV;
import codechicken.lib.vec.Vector3;

public class CCDynamicModel
implements CCRenderState.IVertexSource {
    public final CCRenderState.VertexAttribute[] attributes;

    public CCDynamicModel(CCRenderState.VertexAttribute ... attributes) {
        this.attributes = attributes;
    }

    @Override
    public Vertex5[] getVertices() {
        return new Vertex5[0];
    }

    @Override
    public <T> T getAttributes(CCRenderState.VertexAttribute<T> attr) {
        return null;
    }

    @Override
    public boolean hasAttribute(CCRenderState.VertexAttribute<?> attr) {
        for (CCRenderState.VertexAttribute a : this.attributes) {
            if (a != attr) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareVertex() {
    }

    public CCDynamicModel pos(Vector3 pos) {
        CCRenderState.vert.vec.set(pos);
        return this;
    }

    public CCDynamicModel pos(double x, double y, double z) {
        CCRenderState.vert.vec.set(x, y, z);
        return this;
    }

    public CCDynamicModel tex(UV uv) {
        CCRenderState.vert.uv.set(uv);
        return this;
    }

    public CCDynamicModel tex(double u, double v) {
        CCRenderState.vert.uv.set(u, v);
        return this;
    }

    public CCDynamicModel vert(Vertex5 vert) {
        CCRenderState.vert.set(vert);
        return this;
    }

    public CCDynamicModel normal(Vector3 normal) {
        CCRenderState.normal.set(normal);
        return this;
    }

    public CCDynamicModel normal(double x, double y, double z) {
        CCRenderState.normal.set(x, y, z);
        return this;
    }

    public CCDynamicModel colour(int colour) {
        CCRenderState.colour = colour;
        return this;
    }

    public CCDynamicModel brightness(int brightness) {
        CCRenderState.brightness = brightness;
        return this;
    }

    public CCDynamicModel side(int side) {
        CCRenderState.side = side;
        return this;
    }

    public CCDynamicModel lightCoord(LC lc) {
        CCRenderState.lc = lc;
        return this;
    }

    public void endVertex() {
        CCRenderState.runPipeline();
        CCRenderState.writeVert();
    }
}

