/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.IIndexedCuboidProvider;
import codechicken.lib.vec.Vector3;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HitBoxRenderHandler {
    private static boolean hasInit = false;

    public static void init() {
        if (!hasInit) {
            MinecraftForge.EVENT_BUS.register((Object)new HitBoxRenderHandler());
            hasInit = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        World world = event.getPlayer().field_70170_p;
        EntityPlayer player = event.getPlayer();
        BlockPos pos = event.getTarget().func_178782_a();
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(pos) instanceof IIndexedCuboidProvider) {
            RayTracer rayTracer = new RayTracer();
            IIndexedCuboidProvider provider = (IIndexedCuboidProvider)world.func_175625_s(pos);
            ExtendedMOP hit = rayTracer.rayTraceCuboids(new Vector3(RayTracer.getStartVec(player)), new Vector3(RayTracer.getEndVec(player)), provider.getIndexedCuboids(), new BlockCoord(event.getTarget().func_178782_a()));
            if (hit != null) {
                event.setCanceled(true);
                RenderUtils.renderHitBox(player, provider, hit, event.getPartialTicks());
            }
        }
    }
}

