/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.baked;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.baked.CCBakedQuad;
import codechicken.lib.render.baked.IBakedVertexOperation;

public class CCBakedModel {
    private final CCBakedQuad[] quads;

    public CCBakedModel(CCBakedQuad[] quads) {
        this.quads = quads;
    }

    public void render(IBakedVertexOperation ... transformations) {
        this.render(0, this.quads.length, transformations);
    }

    public void render(int start, int end, IBakedVertexOperation ... transformations) {
        CCRenderState.setVertexRange(start, end);
        for (CCRenderState.vertexIndex = CCRenderState.firstVertexIndex; CCRenderState.vertexIndex < CCRenderState.lastVertexIndex; ++CCRenderState.vertexIndex) {
            CCBakedQuad quad = this.quads[CCRenderState.vertexIndex];
            CCRenderState.vert.set(quad.getVertex());
            CCRenderState.normal.set(quad.getNormal());
            CCRenderState.normalActive = true;
            CCRenderState.colour = quad.getColour();
            CCRenderState.brightness = quad.getLightMap();
            for (IBakedVertexOperation transform : transformations) {
                transform.operateBaked();
            }
            CCRenderState.writeVert();
        }
    }
}

