/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.recipe;

import com.eractnod.ediblebugs.recipe.FryerRecipe;
import com.eractnod.ediblebugs.recipe.ProcessingRecipeSerializer;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum AllRecipes {
    FRYING(() -> new ProcessingRecipeSerializer<FryerRecipe>(FryerRecipe::new), Types.FRYING);

    public IRecipeSerializer<?> serializer;
    public Supplier<IRecipeSerializer<?>> supplier;
    public IRecipeType<? extends IRecipe<? extends IInventory>> type;

    private AllRecipes(Supplier<IRecipeSerializer<?>> supplier, IRecipeType<? extends IRecipe<? extends IInventory>> type) {
        this.supplier = supplier;
        this.type = type;
    }

    public static void register(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        for (AllRecipes r : AllRecipes.values()) {
            r.serializer = r.supplier.get();
            ResourceLocation location = new ResourceLocation("ediblebugs", AllRecipes.asId(r.name()));
            event.getRegistry().register((IForgeRegistryEntry)r.serializer.setRegistryName(location));
        }
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ENGLISH);
    }

    public static class Types {
        public static IRecipeType<FryerRecipe> FRYING = Types.register("frying");

        static <T extends IRecipe<?>> IRecipeType<T> register(final String key) {
            return (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(key), (Object)new IRecipeType<T>(){

                public String toString() {
                    return key;
                }
            });
        }
    }
}

