/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.eb.ediblebugs.tileentity;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class ItemUtil {
    public static int doInsertItem(ISidedInventory inv, int startSlot, int endSlot, ItemStack item) {
        return ItemUtil.doInsertItemInv((IInventory)inv, null, invSlotter.getInstance(startSlot, endSlot), item, null, true);
    }

    private static int doInsertItemInv(IInventory inv, ISidedInventory sidedInv, ISlotIterator slots, ItemStack item, EnumFacing inventorySide, boolean doInsert) {
        int numInserted = 0;
        int numToInsert = item.field_77994_a;
        int firstFreeSlot = -1;
        while (numToInsert > 0 && slots.hasNext()) {
            int slot = slots.nextSlot();
            if (sidedInv != null && !sidedInv.func_180462_a(slot, item, inventorySide)) continue;
            ItemStack contents = inv.func_70301_a(slot);
            if (contents != null) {
                int freeSpace;
                if (!ItemUtil.areStackMergable(contents, item) || (freeSpace = Math.min(inv.func_70297_j_(), contents.func_77976_d()) - contents.field_77994_a) <= 0) continue;
                int noToInsert = Math.min(numToInsert, freeSpace);
                ItemStack toInsert = item.func_77946_l();
                toInsert.field_77994_a = contents.field_77994_a + noToInsert;
                if (sidedInv == null && !inv.func_94041_b(slot, toInsert)) continue;
                numInserted += noToInsert;
                numToInsert -= noToInsert;
                if (!doInsert) continue;
                inv.func_70299_a(slot, toInsert);
                continue;
            }
            if (firstFreeSlot != -1) continue;
            firstFreeSlot = slot;
        }
        if (numToInsert > 0 && firstFreeSlot != -1) {
            ItemStack toInsert = item.func_77946_l();
            toInsert.field_77994_a = ItemUtil.min(numToInsert, inv.func_70297_j_(), toInsert.func_77976_d());
            if (sidedInv != null || inv.func_94041_b(firstFreeSlot, toInsert)) {
                numInserted += toInsert.field_77994_a;
                numToInsert -= toInsert.field_77994_a;
                if (doInsert) {
                    inv.func_70299_a(firstFreeSlot, toInsert);
                }
            }
        }
        if (numInserted > 0 && doInsert) {
            inv.func_70296_d();
        }
        return numInserted;
    }

    private static final int min(int i1, int i2, int i3) {
        return i1 < i2 ? (i1 < i3 ? i1 : i3) : (i2 < i3 ? i2 : i3);
    }

    public static boolean areStackMergable(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null || !s1.func_77985_e() || !s2.func_77985_e()) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    private static final class sidedSlotter
    implements ISlotIterator {
        private static final sidedSlotter me = new sidedSlotter();
        private int[] slots;
        private int current;

        private sidedSlotter() {
        }

        public static final sidedSlotter getInstance(int[] slots) {
            sidedSlotter.me.slots = slots;
            sidedSlotter.me.current = 0;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.slots[this.current++];
        }

        @Override
        public final boolean hasNext() {
            return this.slots != null && this.current < this.slots.length;
        }
    }

    private static final class invSlotter
    implements ISlotIterator {
        private static final invSlotter me = new invSlotter();
        private int end;
        private int current;

        private invSlotter() {
        }

        public static final invSlotter getInstance(int start, int end) {
            invSlotter.me.end = end;
            invSlotter.me.current = start;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.current++;
        }

        @Override
        public final boolean hasNext() {
            return this.current < this.end;
        }
    }

    private static interface ISlotIterator {
        public int nextSlot();

        public boolean hasNext();
    }
}

