/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.eb.ediblebugs.tileentity;

import com.eractnod.eb.ediblebugs.blocks.TermiteBlockClass;
import com.eractnod.eb.ediblebugs.common.EBVarInit;
import com.eractnod.eb.ediblebugs.fakeplayer.EBFakePlayerFactory;
import com.eractnod.eb.ediblebugs.tileentity.ItemUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityBugZapper
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SLOTS_BOTTOM = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SLOTS_SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private NonNullList<ItemStack> zapperItemStacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
    private String zapperName;
    private int timer = 100;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.zapperItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.zapperItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.zapperItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.zapperItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.zapperItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.zapperItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(new BlockPos((Vec3i)this.field_174879_c)) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.zapperItemStacks.clear();
    }

    public void setGuiDisplayName(String string) {
        this.zapperName = string;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.zapperName : "Termite Zapper";
    }

    public boolean func_145818_k_() {
        return this.zapperName != null && this.zapperName.length() > 0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            Item item = stack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if (index < 4) {
                return block instanceof BlockDirt;
            }
            if (index > 7 && index < 18) {
                return true;
            }
            if (index > 3 && index < 8) {
                return stack.func_77973_b() == EBVarInit.termiteLarva;
            }
            return false;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN || direction == EnumFacing.UP && index > 7 && index < 17;
    }

    public void func_73660_a() {
        --this.timer;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (this.timer < 0) {
                this.setDirtBlock();
                this.func_70296_d();
                this.timer = 100;
            }
            this.clickLarveOnDirtBlock();
            this.breakTermiteMound();
            this.doHoover();
        }
    }

    private void doHoover() {
        AxisAlignedBB axis = new AxisAlignedBB(this.field_174879_c, this.field_174879_c).func_186662_g(9.0);
        List listItem = this.field_145850_b.func_72872_a(EntityItem.class, axis);
        for (EntityItem entity : listItem) {
            double z;
            double y;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.25) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, distance / 36.0);
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * speed;
            entity.field_70181_x += y / distance * distScale * 0.2;
            entity.field_70179_y += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K) {
            int numInserted = 0;
            if (entity instanceof EntityItem && !entity.field_70128_L) {
                EntityItem item = (EntityItem)entity;
                ItemStack stack = item.func_92059_d().func_77946_l();
                numInserted = stack.func_77973_b() == EBVarInit.termiteLarva ? ItemUtil.doInsertItem(this, 4, 17, stack) : ItemUtil.doInsertItem(this, 8, 17, stack);
                stack.func_190918_g(numInserted);
                item.func_92058_a(stack);
                if (stack.func_190916_E() == 0) {
                    item.func_70106_y();
                }
            }
        }
    }

    private void breakTermiteMound() {
        Block blockNorth = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3).func_177967_a(EnumFacing.UP, 2)).func_177230_c();
        Block blockSouth = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3).func_177967_a(EnumFacing.UP, 2)).func_177230_c();
        Block blockEast = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.EAST, 3).func_177967_a(EnumFacing.UP, 2)).func_177230_c();
        Block blockWest = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.WEST, 3).func_177967_a(EnumFacing.UP, 2)).func_177230_c();
        Block blockMound = EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.INACTIVE)).func_177230_c();
        if (blockNorth.equals(blockMound)) {
            this.breakMound(EnumFacing.NORTH, blockNorth);
        }
        if (blockSouth.equals(blockMound)) {
            this.breakMound(EnumFacing.SOUTH, blockSouth);
        }
        if (blockEast.equals(blockMound)) {
            this.breakMound(EnumFacing.EAST, blockEast);
        }
        if (blockWest.equals(blockMound)) {
            this.breakMound(EnumFacing.WEST, blockWest);
        }
    }

    private void breakMound(EnumFacing face, Block block) {
        Block blockMound = EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.INACTIVE)).func_177230_c();
        BlockPos blockPos = new BlockPos((Vec3i)this.field_174879_c.func_177967_a(face, 3));
        for (int y = 0; y < 3; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos newpos = new BlockPos(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z);
                    if (this.field_145850_b.func_180495_p(newpos).func_177230_c() != blockMound) continue;
                    this.field_145850_b.func_180495_p(newpos).func_177230_c().func_180657_a(this.field_145850_b, (EntityPlayer)EBFakePlayerFactory.getPlayer((WorldServer)this.field_145850_b), newpos, block.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.INACTIVE)), null, null);
                    this.field_145850_b.func_180501_a(newpos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
    }

    private void clickLarveOnDirtBlock() {
        for (int i = 4; i < 8; ++i) {
            if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3)).func_177230_c() == Blocks.field_150346_d) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3), EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.ACTIVE)));
                this.func_70298_a(i, 1);
            }
            if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3)).func_177230_c() == Blocks.field_150346_d) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3), EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.ACTIVE)));
                this.func_70298_a(i, 1);
            }
            if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.EAST, 3)).func_177230_c() == Blocks.field_150346_d) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.EAST, 3), EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.ACTIVE)));
                this.func_70298_a(i, 1);
            }
            if (((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() || this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.WEST, 3)).func_177230_c() != Blocks.field_150346_d) continue;
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.WEST, 3), EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.ACTIVE)));
            this.func_70298_a(i, 1);
        }
    }

    private void setDirtBlock() {
        if (!this.field_145850_b.field_72995_K) {
            Block blockNorth = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3)).func_177230_c();
            Block blockSouth = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3)).func_177230_c();
            Block blockEast = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.EAST, 3)).func_177230_c();
            Block blockWest = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.WEST, 3)).func_177230_c();
            Block blockMound = EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.ACTIVE)).func_177230_c();
            Block blockMoundI = EBVarInit.termiteBlock.func_176223_P().func_177226_a((IProperty)TermiteBlockClass.VARIANT_PROP, (Comparable)((Object)TermiteBlockClass.EnumType.INACTIVE)).func_177230_c();
            for (int i = 0; i < 4; ++i) {
                if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && blockNorth instanceof BlockAir) {
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3), Blocks.field_150346_d.func_176223_P());
                    this.func_70298_a(i, 1);
                    return;
                }
                if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && blockSouth instanceof BlockAir) {
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3), Blocks.field_150346_d.func_176223_P());
                    this.func_70298_a(i, 1);
                    return;
                }
                if (!((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() && blockEast instanceof BlockAir) {
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.EAST, 3), Blocks.field_150346_d.func_176223_P());
                    this.func_70298_a(i, 1);
                    return;
                }
                if (((ItemStack)this.zapperItemStacks.get(i)).func_190926_b() || !(blockWest instanceof BlockAir)) continue;
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(EnumFacing.WEST, 3), Blocks.field_150346_d.func_176223_P());
                this.func_70298_a(i, 1);
                return;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.zapperItemStacks);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.func_70005_c_());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.zapperItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.zapperItemStacks);
        if (nbt.func_74764_b("CustomeName")) {
            this.zapperName = nbt.func_74779_i("CustomerName");
        }
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_191420_l() {
        return false;
    }
}

