/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.eb.ediblebugs.recipes;

import com.eractnod.eb.ediblebugs.common.EBVarInit;
import com.eractnod.eb.ediblebugs.items.EnumCookedBugs;
import com.eractnod.eb.ediblebugs.items.EnumDirtBugs;
import com.eractnod.eb.ediblebugs.items.EnumGrassBugs;
import com.eractnod.eb.ediblebugs.items.EnumSandBugs;
import com.eractnod.eb.ediblebugs.items.EnumWoodBugs;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FryerRecipes {
    private static final FryerRecipes smeltingBase = new FryerRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static FryerRecipes instance() {
        return smeltingBase;
    }

    private FryerRecipes() {
        this.cookItemstack(new ItemStack(EBVarInit.grassBugs, 1, EnumGrassBugs.GRASSHOPPER_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CGRASSHOPPER_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.grassBugs, 1, EnumGrassBugs.LOCUST_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CLOCUST_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.grassBugs, 1, EnumGrassBugs.CRICKET_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CCRICKET_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.grassBugs, 1, EnumGrassBugs.APHID_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CAPHID_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.dirtBugs, 1, EnumDirtBugs.FIREANT_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CFIREANT_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.dirtBugs, 1, EnumDirtBugs.SLUG_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CSLUG_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.dirtBugs, 1, EnumDirtBugs.SOWBUG_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CSOWBUG_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.dirtBugs, 1, EnumDirtBugs.DUNGBEETLE_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CDUNGBEETLE_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.woodBugs, 1, EnumWoodBugs.CARPENTERANT_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CCARPENTERANT_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.woodBugs, 1, EnumWoodBugs.JUMIL_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CJUMIL_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.woodBugs, 1, EnumWoodBugs.WOODTERMITE_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CWOODTERMITE_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.woodBugs, 1, EnumWoodBugs.WITCHETTYGRUB_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CWITCHETTYGRUB_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.termite, 1, 0), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CTERMITE_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.sandBugs, 1, EnumSandBugs.CAMELSPIDER_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CCAMELSPIDER_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.sandBugs, 1, EnumSandBugs.SCORPION_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CSCORPION_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.sandBugs, 1, EnumSandBugs.CENTIPEDE_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CCENTIPEDE_META), 0.1f);
        this.cookItemstack(new ItemStack(EBVarInit.sandBugs, 1, EnumSandBugs.SCARAB_META), new ItemStack(EBVarInit.cookedBugs, 1, EnumCookedBugs.CSCARAB_META), 0.1f);
        this.cookItem(EBVarInit.termiteClay, new ItemStack(EBVarInit.termiteBrick, 1, 0), 0.1f);
    }

    public void cookBlock(Block p_151393_1_, ItemStack p_151393_2_, float p_151393_3_) {
        this.cookItem(Item.func_150898_a((Block)p_151393_1_), p_151393_2_, p_151393_3_);
    }

    public void cookItem(Item p_151396_1_, ItemStack p_151396_2_, float p_151396_3_) {
        this.cookItemstack(new ItemStack(p_151396_1_, 1, Short.MAX_VALUE), p_151396_2_, p_151396_3_);
    }

    public void cookItemstack(ItemStack p_151394_1_, ItemStack p_151394_2_, float p_151394_3_) {
        this.smeltingList.put(p_151394_1_, p_151394_2_);
        this.experienceList.put(p_151394_2_, Float.valueOf(p_151394_3_));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    public float func_151398_b(ItemStack p_151398_1_) {
        Map.Entry<ItemStack, Float> entry;
        float ret = p_151398_1_.func_77973_b().getSmeltingExperience(p_151398_1_);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.compareItemStacks(p_151398_1_, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }
}

