/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.client.gui.GuiModUpdates;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiModUpdateList
extends GuiScrollingList {
    private GuiModUpdates parent;
    private ArrayList<JsonModUpdate> mods;
    private Map<Integer, ResourceLocation> cachedLogo;
    private Map<Integer, Dimension> cachedLogoDimensions;

    public GuiModUpdateList(GuiModUpdates parent, ArrayList<JsonModUpdate> mods, int listWidth) {
        super(parent.field_146297_k, listWidth, parent.field_146295_m, 32, parent.field_146295_m - 77 + 4, 10, 35, parent.field_146294_l, parent.field_146295_m);
        this.parent = parent;
        this.mods = mods;
        this.cachedLogo = new HashMap<Integer, ResourceLocation>();
        this.cachedLogoDimensions = new HashMap<Integer, Dimension>();
    }

    protected int getSize() {
        return this.mods.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModIndex(index);
    }

    protected boolean isSelected(int index) {
        return this.parent.modIndexSelected(index);
    }

    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    protected int getContentHeight() {
        return this.getSize() * 35 + 1;
    }

    protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
        Minecraft minecraft = Minecraft.func_71410_x();
        JsonModUpdate mc = this.mods.get(idx);
        String name = net.minecraft.util.StringUtils.func_76338_a((String)mc.name);
        String version = net.minecraft.util.StringUtils.func_76338_a((String)mc.getUpdateVersion().getVersionString());
        String type = StringUtils.capitalize((String)mc.updateType.name().toLowerCase());
        FontRenderer font = minecraft.field_71466_p;
        font.func_78276_b(font.func_78269_a(name, this.listWidth - 10), this.left + 36, top + 2, 0xFFFFFF);
        font.func_78276_b(font.func_78269_a(version, this.listWidth - 10), this.left + 36, top + 12, 0xCCCCCC);
        font.func_78276_b(font.func_78269_a(type, this.listWidth - 10), this.left + 36, top + 22, mc.updateType.color);
        if (!this.cachedLogo.containsKey(idx)) {
            BufferedImage logo = mc.thumbnail;
            if (logo != null) {
                this.cachedLogo.put(idx, minecraft.func_110434_K().func_110578_a("mod_thumbnail", new DynamicTexture(logo)));
                this.cachedLogoDimensions.put(idx, new Dimension(logo.getWidth(), logo.getHeight()));
            }
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.field_71446_o.func_110577_a(this.cachedLogo.get(idx));
            double scaleX = (double)this.cachedLogoDimensions.get((Object)Integer.valueOf((int)idx)).width / 32.0;
            double scaleY = (double)this.cachedLogoDimensions.get((Object)Integer.valueOf((int)idx)).height / 32.0;
            double scale = 1.0;
            if (scaleX > 1.0 || scaleY > 1.0) {
                scale = 1.0 / Math.max(scaleX, scaleY);
            }
            double iwidth = (double)this.cachedLogoDimensions.get((Object)Integer.valueOf((int)idx)).width * scale;
            double iheight = (double)this.cachedLogoDimensions.get((Object)Integer.valueOf((int)idx)).height * scale;
            int offset = 12;
            WorldRenderer renderer = tess.func_178180_c();
            renderer.func_178970_b();
            renderer.func_178985_a((double)offset, (double)top + iheight, 0.0, 0.0, 1.0);
            renderer.func_178985_a((double)offset + iwidth, (double)top + iheight, 0.0, 1.0, 1.0);
            renderer.func_178985_a((double)offset + iwidth, (double)top, 0.0, 1.0, 0.0);
            renderer.func_178985_a((double)offset, (double)top, 0.0, 0.0, 0.0);
            tess.func_78381_a();
        }
    }

    public ArrayList<JsonModUpdate> getMods() {
        return this.mods;
    }

    public int getListWidth() {
        return this.listWidth;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setSelected(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }
}

