/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.animation;

import java.util.Random;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.animation.ControlledAnimation;
import net.ilexiconn.llibrary.common.message.MessageLLibraryIntemittentAnimation;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class IntermittentAnimation<T extends Entity>
extends ControlledAnimation {
    private Random rand = new Random();
    private T entity;
    private boolean isRunning;
    private int timeIdle;
    private int minIdleTime;
    private int startProbability;
    private boolean isOperator;
    private byte id;

    public IntermittentAnimation(int id, T entity, int duration, int intervalDuration, int startPropbability, boolean isOperator) {
        super(duration);
        this.id = (byte)id;
        this.entity = entity;
        this.minIdleTime = intervalDuration;
        this.startProbability = startPropbability;
        this.isOperator = isOperator;
        this.isRunning = false;
        this.timerChange = -1;
    }

    public byte getId() {
        return this.id;
    }

    public void setTimeRunning(int timeRunning) {
        this.timer = timeRunning;
        if (this.timer > this.duration) {
            this.timer = this.duration;
        } else if (this.timer < 0) {
            this.timer = 0;
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isRunning) {
            if (this.timer < this.duration && this.timer > 0) {
                this.timer += this.timerChange;
            } else {
                if (this.timer >= this.duration) {
                    this.timer = this.duration;
                } else if (this.timer <= 0) {
                    this.timer = 0;
                }
                this.timeIdle = 0;
                this.isRunning = false;
            }
        } else if (this.isOperator) {
            if (this.timeIdle < this.minIdleTime) {
                ++this.timeIdle;
            } else if (this.rand.nextInt(this.startProbability) == 0) {
                this.start();
                LLibrary.networkWrapper.sendToDimension((IMessage)new MessageLLibraryIntemittentAnimation((Entity)this.entity, this.id), ((Entity)this.entity).field_71093_bK);
            }
        }
    }

    public void start() {
        this.timerChange = -this.timerChange;
        this.timer += this.timerChange;
        this.isRunning = true;
    }

    public void stop() {
        if (this.timer > 0) {
            --this.timer;
        } else {
            this.timer = 0;
            this.isRunning = false;
            this.timeIdle = 0;
            this.timerChange = 1;
        }
    }

    public void stop(int timeDelta) {
        if (this.timer - timeDelta > 0) {
            this.timer -= timeDelta;
        } else {
            this.timer = 0;
            this.isRunning = false;
            this.timeIdle = 0;
            this.timerChange = 1;
        }
    }
}

