/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.content;

import com.google.common.collect.Maps;
import java.util.Map;
import net.ilexiconn.llibrary.common.content.IClientOnlyHandler;
import net.ilexiconn.llibrary.common.content.IContentHandler;
import net.ilexiconn.llibrary.common.content.ITimedHandler;
import net.ilexiconn.llibrary.common.content.InitializationState;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ContentHelper {
    private static Map<InitializationState, IContentHandler> timedHandlers = Maps.newHashMap();

    public static void init(IContentHandler ... contentHandlers) {
        ContentHelper.init(false, contentHandlers);
    }

    public static void init(boolean ignoreTimed, IContentHandler ... contentHandlers) {
        for (IContentHandler contentHandler : contentHandlers) {
            if (!ignoreTimed && contentHandler instanceof ITimedHandler && ((ITimedHandler)((Object)contentHandler)).getTimedState() != InitializationState.PREINIT) {
                timedHandlers.put(((ITimedHandler)((Object)contentHandler)).getTimedState(), contentHandler);
                continue;
            }
            if (contentHandler instanceof IClientOnlyHandler && FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                try {
                    contentHandler.init();
                    contentHandler.gameRegistry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                contentHandler.init();
                contentHandler.gameRegistry();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<InitializationState, IContentHandler> getTimedHandlers() {
        return timedHandlers;
    }
}

