/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.crash;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.IOUtils;

public class SimpleCrashReport {
    public String description;
    public Throwable throwable;

    public SimpleCrashReport(String d, Throwable t) {
        this.description = d;
        this.throwable = t;
    }

    public static String makeCrashReport(Throwable e, String d) {
        return new SimpleCrashReport(d, e).getCompleteReport();
    }

    public String getCompleteReport() {
        return "---- Crash Report ----\n\nDescription: " + this.description + "\n\n-- Crash Log --\n" + this.getStackTrace() + "\n-- System Details --\n" + this.getSystemDetails();
    }

    public String getSystemDetails() {
        String s = "";
        s = s + this.toPrettyString("Minecraft Version", "1.8");
        s = s + this.toPrettyString("Operating System", System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
        s = s + this.toPrettyString("Java Version", System.getProperty("java.version"));
        s = s + this.toPrettyString("Development Environment", Launch.blackboard.get("fml.deobfuscatedEnvironment") + "");
        return s;
    }

    public String toPrettyString(String key, String value) {
        return "\t" + key + ": " + value + "\n";
    }

    public String getStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.throwable.printStackTrace(printWriter);
        String s = stringWriter.toString();
        IOUtils.closeQuietly((Writer)stringWriter);
        IOUtils.closeQuietly((Writer)printWriter);
        return s;
    }
}

