/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.json.container;

import com.google.gson.annotations.SerializedName;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.common.config.LLibraryConfigHandler;
import net.ilexiconn.llibrary.common.update.UpdateType;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;

public class JsonModUpdate {
    public transient boolean updated;
    public transient ModContainer modContainer;
    public transient String modid;
    public transient String name;
    public transient String currentVersion;
    public transient BufferedImage thumbnail;
    public transient UpdateType updateType;
    private transient ArtifactVersion releaseVersion;
    private transient ArtifactVersion betaVersion;
    private transient ArtifactVersion alphaVersion;
    private Map<String, List<String>> versions;
    private String updateUrl;
    private String iconUrl;
    @Deprecated
    private String newestVersion;
    private String release;
    private String beta;
    private String alpha;
    @SerializedName(value="directUpdateUrl-1.8")
    private String directUpdateUrl;

    public Map<String, List<String>> getVersions() {
        return this.versions;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public ArtifactVersion getRelease() {
        if (this.releaseVersion == null) {
            this.releaseVersion = new DefaultArtifactVersion(this.modid, this.release == null ? this.newestVersion : this.release);
        }
        return this.releaseVersion;
    }

    public ArtifactVersion getBeta() {
        if (this.betaVersion == null && this.beta != null) {
            this.betaVersion = new DefaultArtifactVersion(this.modid, this.beta);
        }
        return this.betaVersion;
    }

    public ArtifactVersion getAlpha() {
        if (this.alphaVersion == null && this.alpha != null) {
            this.alphaVersion = new DefaultArtifactVersion(this.modid, this.alpha);
        }
        return this.alphaVersion;
    }

    public ArtifactVersion getUpdateVersion() {
        switch (LLibraryConfigHandler.updateType) {
            case ALPHA: {
                if (this.getAlpha() != null) {
                    this.updateType = UpdateType.ALPHA;
                    return this.getAlpha();
                }
                if (this.getBeta() != null) {
                    this.updateType = UpdateType.BETA;
                    return this.getBeta();
                }
                this.updateType = UpdateType.RELEASE;
                return this.getRelease();
            }
            case BETA: {
                if (this.getBeta() != null) {
                    this.updateType = UpdateType.BETA;
                    return this.getBeta();
                }
                this.updateType = UpdateType.RELEASE;
                return this.getRelease();
            }
        }
        this.updateType = UpdateType.RELEASE;
        return this.getRelease();
    }

    public String getDirectUpdateUrl() {
        return this.directUpdateUrl;
    }
}

