/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.message;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ByteBufHelper {
    public static void writeObject(ByteBuf buffer, Object object) throws IllegalAccessException {
        for (Field field : object.getClass().getDeclaredFields()) {
            Class<?> type = field.getType();
            ByteBufHelper.writeByType(buffer, object, field, type);
        }
    }

    public static <T> T readObject(ByteBuf buffer, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        T object = clazz.newInstance();
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> type = field.getType();
            field.set(object, ByteBufHelper.readByType(buffer, type));
        }
        return object;
    }

    private static void writeByType(ByteBuf buffer, Object object, Field field, Class<?> type) throws IllegalAccessException {
        if (type == Integer.class) {
            buffer.writeInt(field.getInt(object));
        } else if (type == Double.class) {
            buffer.writeDouble(field.getDouble(object));
        } else if (type == Float.class) {
            buffer.writeFloat(field.getFloat(object));
        } else if (type == String.class) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)field.get(object)));
        } else if (type == Long.class) {
            buffer.writeLong(((Long)field.get(object)).longValue());
        } else if (type == Short.class) {
            buffer.writeShort((int)((Short)field.get(object)).shortValue());
        } else if (type == Boolean.class) {
            buffer.writeBoolean(((Boolean)field.get(object)).booleanValue());
        } else if (type == Byte.class) {
            buffer.writeByte((int)((Byte)field.get(object)).byteValue());
        } else {
            ByteBufHelper.writeObject(buffer, field.get(object));
        }
    }

    private static Object readByType(ByteBuf buffer, Class<?> type) throws IllegalAccessException, InstantiationException {
        if (type == Integer.class) {
            return buffer.readInt();
        }
        if (type == Double.class) {
            return buffer.readDouble();
        }
        if (type == Float.class) {
            return Float.valueOf(buffer.readFloat());
        }
        if (type == String.class) {
            return ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        if (type == Long.class) {
            return buffer.readLong();
        }
        if (type == Short.class) {
            return buffer.readShort();
        }
        if (type == Boolean.class) {
            return buffer.readBoolean();
        }
        if (type == Byte.class) {
            return buffer.readByte();
        }
        return ByteBufHelper.readObject(buffer, type);
    }
}

