/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.nbt.io;

import java.lang.reflect.Field;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.common.crash.SimpleCrashReport;
import net.ilexiconn.llibrary.common.nbt.tag.NBTTagBoolean;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTIO {
    public static <T> T fromNbt(NBTTagCompound tag, Class<T> type) {
        try {
            Field[] fields;
            T t = type.newInstance();
            if (tag.func_82582_d()) {
                return t;
            }
            for (Field field : fields = type.getFields()) {
                if (!tag.func_74764_b(field.getName())) continue;
                field.setAccessible(true);
                field.set(t, NBTIO.getValue(tag.func_74781_a(field.getName())));
            }
            return t;
        }
        catch (Exception e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Unable to load " + type + " from nbt " + tag));
            return null;
        }
    }

    public static void toNbt(NBTTagCompound tag, Object object) {
        Class<?> type = object.getClass();
        try {
            Field[] fields;
            for (Field field : fields = type.getFields()) {
                tag.func_74782_a(field.getName(), NBTIO.getType(field.get(object)));
            }
        }
        catch (Exception e) {
            LLibrary.logger.error(SimpleCrashReport.makeCrashReport(e, "Unable to save " + type + " to nbt " + tag));
        }
    }

    private static Object getValue(NBTBase type) {
        if (type instanceof NBTTagBoolean) {
            return ((NBTTagBoolean)type).func_150290_f() == 1;
        }
        if (type instanceof NBTTagByte) {
            return ((NBTTagByte)type).func_150290_f();
        }
        if (type instanceof NBTTagShort) {
            return ((NBTTagShort)type).func_150289_e();
        }
        if (type instanceof NBTTagInt) {
            return ((NBTTagInt)type).func_150287_d();
        }
        if (type instanceof NBTTagLong) {
            return ((NBTTagLong)type).func_150291_c();
        }
        if (type instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)type).func_150288_h());
        }
        if (type instanceof NBTTagDouble) {
            return ((NBTTagDouble)type).func_150286_g();
        }
        if (type instanceof NBTTagString) {
            return type.toString();
        }
        if (type instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)type).func_150292_c();
        }
        if (type instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)type).func_150302_c();
        }
        return type;
    }

    private static NBTBase getType(Object value) {
        if (value instanceof Boolean) {
            return new NBTTagBoolean((Boolean)value);
        }
        if (value instanceof Byte) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value instanceof byte[]) {
            return new NBTTagByteArray((byte[])value);
        }
        if (value instanceof int[]) {
            return new NBTTagIntArray((int[])value);
        }
        return null;
    }
}

