/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.plugin;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.common.json.JsonFactory;
import net.ilexiconn.llibrary.common.json.container.JsonUpdateEntry;
import net.ilexiconn.llibrary.common.log.LoggerHelper;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;

@IFMLLoadingPlugin.Name(value="LLibrary")
@IFMLLoadingPlugin.MCVersion(value="1.8")
public class LLibraryPlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static LoggerHelper logger = new LoggerHelper("LLibraryUpdater");

    public Void call() throws Exception {
        logger.info("Searching for mod updates");
        File mods = new File("mods");
        File file = new File("updatequeue.json");
        if (file.exists()) {
            List updateQueue;
            try {
                updateQueue = (List)JsonFactory.getGson().fromJson((Reader)new FileReader(file), new TypeToken<List<JsonUpdateEntry>>(){}.getType());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            for (JsonUpdateEntry entry : updateQueue) {
                File modFile = new File(mods, entry.getFile());
                if (modFile.exists()) {
                    logger.info("Deleting old mod jar " + modFile.getName() + " from mod " + entry.getName() + " (" + entry.getModid() + ")");
                    try {
                        FileDeleteStrategy.FORCE.delete(modFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                File mod = new File(mods, entry.getName() + "-" + entry.getVersion() + "-" + "1.8" + ".jar");
                logger.info("Downloading new mod jar " + mod.getName() + " for mod " + entry.getName() + " (" + entry.getModid() + ")");
                FileUtils.copyURLToFile((URL)new URL(entry.getUrl()), (File)mod);
            }
            try {
                System.gc();
                FileDeleteStrategy.FORCE.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

