/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.world.gen;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class WorldHeightmapGenerator {
    public byte[][] heightmap;
    public byte[][] biomemap;
    public int width;
    public int height;
    public int biomeWidth;
    public int biomeHeight;
    private Map<Integer, BiomeGenBase> biomes = new HashMap<Integer, BiomeGenBase>();
    private double biomemapToHeightmapWidthRatio;
    private double biomemapToHeightmapHeightRatio;
    private boolean loaded;

    public abstract String getBiomeMapLocation();

    public abstract String getHeightmapLocation();

    public abstract double getWorldScale();

    public abstract double getHeightScale(int var1);

    public int getHeightOffset(int height) {
        return 0;
    }

    public abstract IBlockState getStoneBlock();

    public abstract BiomeGenBase getDefaultBiome();

    public abstract String getName();

    public abstract int getColourForBiome(BiomeGenBase var1);

    public abstract int getWorldOffsetX();

    public abstract int getWorldOffsetZ();

    public abstract boolean hasOcean();

    public abstract IBlockState getOceanLiquid();

    public abstract int getOceanHeight(int var1, int var2);

    public void loadHeightmap() {
        LLibrary.logger.info("Loading " + this.getName() + " Heightmap...");
        try {
            BufferedImage image = ImageIO.read(LLibrary.class.getResourceAsStream(this.getHeightmapLocation()));
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.heightmap = new byte[this.width][this.height];
            Random random = new Random(Long.MAX_VALUE);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int height = image.getRGB(x, y) & 0xFF;
                    height = (int)((double)height * this.getHeightScale(height));
                    if ((height += this.getHeightOffset(height)) + 5 > 255) {
                        height = 250;
                    }
                    this.heightmap[x][y] = height <= 1 ? (byte)(random.nextInt(5) + 25 - 128) : (byte)(height - 128);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadBiomemap() {
        String biomeMapLocation = this.getBiomeMapLocation();
        if (biomeMapLocation != null) {
            LLibrary.logger.info("Loading " + this.getName() + " Biomemap..");
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                this.biomes.put(this.getColourForBiome(biome), biome);
            }
            try {
                BufferedImage biomeImage = ImageIO.read(LLibrary.class.getResourceAsStream(biomeMapLocation));
                this.biomeWidth = biomeImage.getWidth();
                this.biomeHeight = biomeImage.getHeight();
                this.biomemap = new byte[this.biomeWidth][this.biomeHeight];
                for (int y = 0; y < this.biomeHeight; ++y) {
                    block4: for (int x = 0; x < this.biomeWidth; ++x) {
                        this.biomemap[x][y] = (byte)this.getDefaultBiome().field_76756_M;
                        for (Map.Entry<Integer, BiomeGenBase> entry : this.biomes.entrySet()) {
                            if (!this.isSimilarColour(biomeImage.getRGB(x, y), entry.getKey())) continue;
                            this.biomemap[x][y] = (byte)entry.getValue().field_76756_M;
                            continue block4;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.biomemapToHeightmapHeightRatio = (double)this.biomeHeight / (double)this.height;
            this.biomemapToHeightmapWidthRatio = (double)this.biomeWidth / (double)this.width;
        }
    }

    private boolean isSimilarColour(int colour, int desiredColour) {
        int r1 = colour & 0xFF;
        int g1 = colour >> 8 & 0xFF;
        int b1 = colour >> 16 & 0xFF;
        int r2 = desiredColour & 0xFF;
        int g2 = desiredColour >> 8 & 0xFF;
        int b2 = desiredColour >> 16 & 0xFF;
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2) < 10;
    }

    private int getHeight(int x, int y) {
        return this.heightmap[x][y] + 128;
    }

    public int getHeightForCoords(int x, int z) {
        double scale = this.getWorldScale();
        int scaledWidth = (int)((double)this.width * scale);
        int scaledHeight = (int)((double)this.height * scale);
        double offsetX = this.getWorldOffsetX();
        double offsetZ = this.getWorldOffsetZ();
        if (offsetX != 0.0) {
            offsetX /= scale;
        }
        if (offsetZ != 0.0) {
            offsetZ /= scale;
        }
        x = (int)((double)x - offsetX);
        z = (int)((double)z - offsetZ);
        if (x < 0 || z < 0 || x >= scaledWidth || z >= scaledHeight) {
            return 10;
        }
        BicubicInterpolator bi = new BicubicInterpolator();
        return bi.getValue(this.heightmap, x, z, scale) + 128;
    }

    public BiomeGenBase getBiomeAt(int x, int z) {
        if (this.biomemap != null) {
            double scale = this.getWorldScale();
            int scaledWidth = (int)((double)this.width * scale);
            int scaledHeight = (int)((double)this.height * scale);
            double offsetX = this.getWorldOffsetX();
            double offsetZ = this.getWorldOffsetZ();
            if (offsetX != 0.0) {
                offsetX /= scale;
            }
            if (offsetZ != 0.0) {
                offsetZ /= scale;
            }
            x = (int)((double)x - offsetX);
            z = (int)((double)z - offsetZ);
            if (x < 0 || z < 0 || x >= scaledWidth || z >= scaledHeight) {
                return this.getDefaultBiome();
            }
            double newX = (double)x * this.biomemapToHeightmapWidthRatio / scale;
            double newZ = (double)z * this.biomemapToHeightmapHeightRatio / scale;
            return BiomeGenBase.func_150568_d((int)this.biomemap[(int)Math.round(newX)][(int)Math.round(newZ)]);
        }
        return this.getDefaultBiome();
    }

    public void load() {
        this.loaded = true;
        this.loadHeightmap();
        this.loadBiomemap();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static class BicubicInterpolator
    extends CubicInterpolator {
        private byte[] arr = new byte[4];

        public byte getValue(byte[][] p, double x, double y, double scale) {
            int xi = (int)(x /= scale);
            this.arr[0] = BicubicInterpolator.getValue(p[Math.max(0, xi - 1)], y, scale);
            this.arr[1] = BicubicInterpolator.getValue(p[xi], y, scale);
            this.arr[2] = BicubicInterpolator.getValue(p[Math.min(p.length - 1, xi + 1)], y, scale);
            this.arr[3] = BicubicInterpolator.getValue(p[Math.min(p.length - 1, xi + 2)], y, scale);
            return BicubicInterpolator.getValue(this.arr, (x -= (double)xi) + 1.0, scale);
        }
    }

    public static class CubicInterpolator {
        public static byte getValue(byte[] p, double x, double scale) {
            int xi = (int)(x /= scale);
            double p0 = p[Math.max(0, xi - 1)];
            double p1 = p[xi];
            double p2 = p[Math.min(p.length - 1, xi + 1)];
            double p3 = p[Math.min(p.length - 1, xi + 2)];
            return (byte)Math.round(p1 + 0.5 * (x -= (double)xi) * (p2 - p0 + x * (2.0 * p0 - 5.0 * p1 + 4.0 * p2 - p3 + x * (3.0 * (p1 - p2) + p3 - p0))));
        }
    }
}

