/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.world.gen.gen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.ilexiconn.llibrary.common.world.gen.gen.WorldHeightmapGenerator;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldChunkManagerHeightmap
extends WorldChunkManager {
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List biomesToSpawnIn = Lists.newArrayList();
    private String field_180301_f = "";
    private long seed;
    private WorldHeightmapGenerator generator;

    protected WorldChunkManagerHeightmap(WorldHeightmapGenerator generator) {
        this.biomesToSpawnIn.addAll(allowedBiomes);
        this.generator = generator;
    }

    public WorldChunkManagerHeightmap(long seed, WorldType worldType, String p_i45744_4_, WorldHeightmapGenerator generator) {
        this(generator);
        this.field_180301_f = p_i45744_4_;
        this.seed = seed;
    }

    public WorldChunkManagerHeightmap(World worldIn, WorldHeightmapGenerator generator) {
        this(worldIn.func_72905_C(), worldIn.func_72912_H().func_76067_t(), worldIn.func_72912_H().func_82571_y(), generator);
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public BiomeGenBase func_180300_a(BlockPos pos, BiomeGenBase biome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), biome);
    }

    public float[] func_76936_a(float[] listToReuse, int x, int z, int width, int length) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new float[width * length];
        }
        int i = 0;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                try {
                    float f = (float)BiomeGenBase.func_180276_a((int)this.getBiomeAt((int)x, (int)z).field_76756_M, (BiomeGenBase)BiomeGenBase.field_180279_ad).func_76744_g() / 65536.0f;
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    listToReuse[i] = f;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                    crashreportcategory.func_71507_a("downfalls[] size", (Object)listToReuse.length);
                    crashreportcategory.func_71507_a("x", (Object)x);
                    crashreportcategory.func_71507_a("z", (Object)z);
                    crashreportcategory.func_71507_a("w", (Object)width);
                    crashreportcategory.func_71507_a("h", (Object)length);
                    throw new ReportedException(crashreport);
                }
                ++i;
            }
        }
        return listToReuse;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float p_76939_1_, int p_76939_2_) {
        return p_76939_1_;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new BiomeGenBase[width * height];
        }
        try {
            int i = 0;
            for (int partZ = 0; partZ < height; ++partZ) {
                for (int partX = 0; partX < width; ++partX) {
                    biomes[i] = this.getBiomeAt(partX + x, partZ + z);
                    ++i;
                }
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase1 = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiomegenbase1, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int i = 0;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                listToReuse[i] = this.getBiomeAt(partX + x, partZ + z);
                ++i;
            }
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List allowed) {
        IntCache.func_76446_a();
        int l = x - radius >> 2;
        int i1 = z - radius >> 2;
        int j1 = x + radius >> 2;
        int k1 = z + radius >> 2;
        int width = j1 - l + 1;
        int length = k1 - i1 + 1;
        try {
            for (int partZ = 0; partZ < length; ++partZ) {
                for (int partX = 0; partX < width; ++partX) {
                    BiomeGenBase biomegenbase = this.getBiomeAt(partX + x, partZ + z);
                    if (allowed.contains(biomegenbase)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", (Object)allowed);
            throw new ReportedException(crashreport);
        }
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random random) {
        IntCache.func_76446_a();
        int l = x - range >> 2;
        int i1 = z - range >> 2;
        int j1 = x + range >> 2;
        int k1 = z + range >> 2;
        int width = j1 - l + 1;
        int length = k1 - i1 + 1;
        BlockPos blockpos = null;
        int j2 = 0;
        int i = 0;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                int chunkX = l + i % width << 2;
                int chunkZ = i1 + i / width << 2;
                BiomeGenBase biomegenbase = this.getBiomeAt(partX + x, partZ + z);
                if (biomes.contains(biomegenbase) && (blockpos == null || random.nextInt(j2 + 1) == 0)) {
                    blockpos = new BlockPos(chunkX, 0, chunkZ);
                    ++j2;
                }
                ++i;
            }
        }
        return blockpos;
    }

    private BiomeGenBase getBiomeAt(int x, int z) {
        return this.generator.getBiomeAt(x, z);
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newBiomeGens;
    }
}

