/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.entity;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.entity.EntityProperties;
import net.ilexiconn.llibrary.server.entity.PropertiesTracker;
import net.ilexiconn.llibrary.server.util.WeakIdentityHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.IExtendedEntityProperties;

public enum EntityPropertiesHandler {
    INSTANCE;

    private Map<Class<? extends EntityProperties>, String> propertiesIDMap = new HashMap<Class<? extends EntityProperties>, String>();
    private Map<Class<? extends Entity>, List<Class<? extends EntityProperties<?>>>> registeredProperties = new HashMap();
    private Map<Class<? extends Entity>, List<String>> entityPropertiesCache = new HashMap<Class<? extends Entity>, List<String>>();
    private Map<EntityPlayerMP, List<PropertiesTracker<?>>> trackerMap = new WeakIdentityHashMap();

    public <E extends Entity, T extends EntityProperties<E>> void registerProperties(Class<T> propertiesClass) {
        EntityProperties properties;
        try {
            Constructor<T> constructor = propertiesClass.getConstructor(new Class[0]);
            properties = (EntityProperties)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LLibrary.LOGGER.fatal("Failed to register entity properties", (Throwable)e);
            return;
        }
        if (this.propertiesIDMap.containsValue(properties.getID())) {
            LLibrary.LOGGER.fatal("Duplicate entity properties with ID " + properties.getID());
            return;
        }
        this.propertiesIDMap.put(propertiesClass, properties.getID());
        Class entityClass = properties.getEntityClass();
        List<Class<EntityProperties<?>>> list = this.registeredProperties.get(entityClass);
        if (list == null) {
            list = new ArrayList();
            this.registeredProperties.put(entityClass, list);
        }
        list.add(propertiesClass);
    }

    public <T extends EntityProperties<?>> T getProperties(Entity entity, Class<T> propertiesClass) {
        if (entity != null && this.propertiesIDMap.containsKey(propertiesClass)) {
            return (T)((EntityProperties)entity.getExtendedProperties(this.propertiesIDMap.get(propertiesClass)));
        }
        return null;
    }

    public <T extends Entity> void addTracker(EntityPlayerMP player, T entity) {
        List<String> entityProperties = this.entityPropertiesCache.get(entity.getClass());
        if (entityProperties != null) {
            List<PropertiesTracker<?>> trackerList = this.trackerMap.get(player);
            if (trackerList == null) {
                trackerList = new ArrayList();
                this.trackerMap.put(player, trackerList);
            }
            for (String propID : entityProperties) {
                EntityProperties properties;
                IExtendedEntityProperties extendedProperties = entity.getExtendedProperties(propID);
                if (!(extendedProperties instanceof EntityProperties) || (properties = (EntityProperties)extendedProperties).getTrackingTime() < 0) continue;
                PropertiesTracker<T> tracker = properties.createTracker(entity);
                tracker.setReady();
                trackerList.add(tracker);
            }
        }
    }

    public void removeTracker(EntityPlayerMP player, Entity entity) {
        List<PropertiesTracker<?>> trackerList = this.trackerMap.get(player);
        if (trackerList != null && trackerList.size() > 0) {
            Iterator<PropertiesTracker<?>> iterator = trackerList.iterator();
            while (iterator.hasNext()) {
                PropertiesTracker<?> tracker = iterator.next();
                if (!tracker.getEntity().equals((Object)entity)) continue;
                iterator.remove();
                tracker.removeTracker();
            }
        }
    }

    public void removePlayer(EntityPlayerMP player) {
        List<PropertiesTracker<?>> trackers = this.trackerMap.get(player);
        if (trackers != null && trackers.size() > 0) {
            trackers.forEach(PropertiesTracker::removeTracker);
        }
        this.trackerMap.remove(player);
    }

    public boolean hasEntityInCache(Class<? extends Entity> entityClass) {
        return this.entityPropertiesCache.containsKey(entityClass);
    }

    public void addEntityToCache(Class<? extends Entity> entityClass, List<String> propertyIDs) {
        this.entityPropertiesCache.put(entityClass, propertyIDs);
    }

    public Stream<Map.Entry<Class<? extends Entity>, List<Class<? extends EntityProperties<?>>>>> getRegisteredProperties() {
        return this.registeredProperties.entrySet().stream();
    }

    public List<PropertiesTracker<?>> getEntityTrackers(EntityPlayerMP player) {
        return this.trackerMap.get(player);
    }

    public Iterator<Map.Entry<EntityPlayerMP, List<PropertiesTracker<?>>>> getTrackerIterator() {
        return this.trackerMap.entrySet().iterator();
    }
}

