/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.ilexiconn.llibrary.server.structure.RotationAngle;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public abstract class StructureGenerator {
    public static final List<EnumFacing> CLOCKWISE_FACINGS = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST});

    public static EnumFacing getNextClockwise(EnumFacing facing) {
        int index = CLOCKWISE_FACINGS.indexOf(facing);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        ++index;
        return CLOCKWISE_FACINGS.get(index %= CLOCKWISE_FACINGS.size());
    }

    public abstract void generate(World var1, int var2, int var3, int var4, Random var5);

    public abstract StructureGenerator rotateClockwise(RotationAngle var1);

    public abstract StructureGenerator rotateTowards(EnumFacing var1);
}

