/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorElement<T extends GuiScreen>
extends Element<T> {
    public int[] colors = new int[]{-83455, -29952, -564722, -3518449, -2475263, -1087152, -3132360, -48572, -1685418, -1568477, -1441697, -3932078, -1900405, -4325001, -3982925, -6618998, -16681001, -16751695, -7172138, -9737770, -7904072, -9155160, -5224766, -7923817, -16737861, -13796198, -16664636, -16547192, -16731500, -16677259, -16724368, -15693762, -8752012, -10593705, -9996663, -11510678, -11043724, -11966368, -11894267, -15696881, -9013642, -11843000, -9799298, -11775141, -10191772, -11313836, -8161980, -8490145};
    private int horizontalRows;
    private int selectedColor = -1;
    private Function<ColorElement<T>, Boolean> function;

    public ColorElement(T gui, float posX, float posY, int width, int height, Function<ColorElement<T>, Boolean> function) {
        super(gui, posX, posY, width, height);
        this.horizontalRows = (int)Math.ceil(width / 23);
        this.function = function;
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX() + 1.0f, this.getPosY() + 1.0f, this.getWidth() - 1, this.getHeight() - 1, LLibrary.CONFIG.getSecondaryColor());
        float offsetX = this.getWidth() / 2 - (this.horizontalRows * 23 + 4) / 2;
        float offsetY = this.getHeight() / 2 - (this.colors.length / this.horizontalRows * 23 + 4) / 2;
        for (int i = 0; i < this.colors.length; ++i) {
            int color = this.colors[i];
            int x = i % this.horizontalRows * 23 + 4;
            int y = i / this.horizontalRows * 23 + 4;
            this.drawRectangle(this.getPosX() + (float)x + offsetX, this.getPosY() + (float)y + offsetY, 20.0, 20.0, color);
            if (color != LLibrary.CONFIG.getAccentColor()) continue;
            if (this.selectedColor == -1) {
                this.selectedColor = i;
            }
            this.drawOutline(this.getPosX() + (float)x + offsetX, this.getPosY() + (float)y + offsetY, 20.0, 20.0, LLibrary.CONFIG.getTextColor(), 2.0);
        }
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        float offsetX = this.getWidth() / 2 - (this.horizontalRows * 23 + 4) / 2;
        float offsetY = this.getHeight() / 2 - (this.colors.length / this.horizontalRows * 23 + 4) / 2;
        for (int i = 0; i < this.colors.length; ++i) {
            float x = this.getPosX() + (float)(i % this.horizontalRows * 23) + 4.0f + offsetX;
            float y = this.getPosY() + (float)(i / this.horizontalRows * 23) + 4.0f + offsetY;
            if (button != 0 || !(mouseX >= x) || !(mouseX <= x + 20.0f) || !(mouseY >= y) || !(mouseY <= y + 20.0f) || LLibrary.CONFIG.getAccentColor() == this.colors[i]) continue;
            this.selectedColor = this.colors[i];
            if (this.function.apply(this).booleanValue()) {
                ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            return true;
        }
        return false;
    }

    public int getColor() {
        return this.selectedColor;
    }
}

