/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.update;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import net.ilexiconn.llibrary.client.gui.update.ModUpdateEntryGUI;
import net.ilexiconn.llibrary.client.gui.update.ModUpdateListGUI;
import net.ilexiconn.llibrary.server.update.UpdateContainer;
import net.ilexiconn.llibrary.server.update.UpdateHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModUpdateGUI
extends GuiScreen {
    private GuiMainMenu parent;
    private ModUpdateListGUI modList;
    private ModUpdateEntryGUI modInfo;
    private int selected = -1;
    private GuiButton buttonUpdate;
    private GuiButton buttonDone;

    public ModUpdateGUI(GuiMainMenu parent) {
        this.parent = parent;
    }

    public ModUpdateListGUI getModList() {
        return this.modList;
    }

    public ModUpdateEntryGUI getModInfo() {
        return this.modInfo;
    }

    public void func_73866_w_() {
        int width = 0;
        for (UpdateContainer mod : UpdateHandler.INSTANCE.getOutdatedModList()) {
            width = Math.max(width, this.field_146289_q.func_78256_a(mod.getModContainer().getName()) + 47);
            width = Math.max(width, this.field_146289_q.func_78256_a(mod.getModContainer().getVersion()) + 47);
        }
        width = Math.min(width, 150);
        this.modList = new ModUpdateListGUI(this, width);
        this.buttonDone = new GuiButton(6, (this.modList.getRight() + this.field_146294_l) / 2 - 100, this.field_146295_m - 38, StatCollector.func_74838_a((String)"gui.done"));
        this.field_146292_n.add(this.buttonDone);
        this.buttonUpdate = new GuiButton(20, 10, this.field_146295_m - 38, this.modList.getWidth(), 20, StatCollector.func_74838_a((String)"gui.llibrary.update"));
        this.field_146292_n.add(this.buttonUpdate);
        this.updateModInfo();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 6: {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                    return;
                }
                case 20: {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) break;
                    try {
                        desktop.browse(new URI(UpdateHandler.INSTANCE.getOutdatedModList().get(this.selected).getUpdateURL()));
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        super.func_146284_a(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (UpdateHandler.INSTANCE.getOutdatedModList().isEmpty()) {
            this.func_146276_q_();
            int i = this.field_146294_l / 2;
            int j = this.field_146295_m / 2;
            this.buttonDone.field_146128_h = this.field_146294_l / 2 - 100;
            this.buttonDone.field_146129_i = this.field_146295_m - 38;
            this.field_146292_n.clear();
            this.field_146292_n.add(this.buttonDone);
            this.drawScaledString(StatCollector.func_74838_a((String)"gui.llibrary.updated.1"), i, j - 40, 0xFFFFFF, 2.0f);
            this.drawScaledString(StatCollector.func_74838_a((String)"gui.llibrary.updated.2"), i, j - 15, 0xFFFFFF, 1.0f);
        } else {
            this.modList.drawScreen(mouseX, mouseY, partialTicks);
            if (this.modInfo != null) {
                this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
            }
            int left = (this.field_146294_l - this.modList.getWidth() - 38) / 2 + this.modList.getWidth() + 30;
            this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"gui.llibrary.update.title"), left, 16, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void selectModIndex(int index) {
        if (this.selected != index) {
            this.selected = index;
            this.updateModInfo();
        }
    }

    public boolean modIndexSelected(int index) {
        return this.selected == index;
    }

    private void updateModInfo() {
        this.buttonUpdate.field_146125_m = false;
        this.modInfo = null;
        if (this.selected == -1) {
            return;
        }
        ArrayList<String> textList = new ArrayList<String>();
        this.buttonUpdate.field_146125_m = true;
        this.buttonUpdate.field_146124_l = true;
        this.buttonUpdate.field_146126_j = StatCollector.func_74838_a((String)"gui.llibrary.update");
        UpdateContainer updateContainer = UpdateHandler.INSTANCE.getOutdatedModList().get(this.selected);
        textList.add(updateContainer.getModContainer().getName());
        textList.add(StatCollector.func_74838_a((String)"gui.llibrary.currentVersion") + String.format(": %s", updateContainer.getModContainer().getVersion()));
        textList.add(StatCollector.func_74838_a((String)"gui.llibrary.latestVersion") + String.format(": %s", updateContainer.getLatestVersion().getVersionString()));
        textList.add(null);
        Collections.addAll(textList, UpdateHandler.INSTANCE.getChangelog(updateContainer, updateContainer.getLatestVersion()));
        this.modInfo = new ModUpdateEntryGUI(this, this.field_146294_l - this.modList.getWidth() - 30, textList);
    }

    public void drawScaledString(String text, int x, int y, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.func_73732_a(this.field_146289_q, text, (int)((float)x / scale), (int)((float)y / scale), color);
        GL11.glPopMatrix();
    }

    public boolean func_175276_a(IChatComponent component) {
        return super.func_175276_a(component);
    }
}

