/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tabula.baked.deserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class ItemTransformVec3fDeserializer
implements JsonDeserializer<ItemTransformVec3f> {
    private static final Vector3f ROTATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f TRANSLATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f SCALE_DEFAULT = new Vector3f(1.0f, 1.0f, 1.0f);

    public ItemTransformVec3f deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = element.getAsJsonObject();
        Vector3f rotation = this.parseVector3f(object, "rotation", ROTATION_DEFAULT);
        Vector3f translation = this.parseVector3f(object, "translation", TRANSLATION_DEFAULT);
        translation.scale(0.0625f);
        translation.x = MathHelper.func_76131_a((float)translation.x, (float)-5.0f, (float)5.0f);
        translation.y = MathHelper.func_76131_a((float)translation.y, (float)-5.0f, (float)5.0f);
        translation.z = MathHelper.func_76131_a((float)translation.z, (float)-5.0f, (float)5.0f);
        Vector3f scale = this.parseVector3f(object, "scale", SCALE_DEFAULT);
        scale.x = MathHelper.func_76131_a((float)scale.x, (float)-4.0f, (float)4.0f);
        scale.y = MathHelper.func_76131_a((float)scale.y, (float)-4.0f, (float)4.0f);
        scale.z = MathHelper.func_76131_a((float)scale.z, (float)-4.0f, (float)4.0f);
        return new ItemTransformVec3f(rotation, translation, scale);
    }

    private Vector3f parseVector3f(JsonObject object, String key, Vector3f defaultValue) {
        if (!object.has(key)) {
            return defaultValue;
        }
        JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)object, (String)key);
        if (jsonarray.size() != 3) {
            throw new JsonParseException("Expected 3 " + key + " values, found: " + jsonarray.size());
        }
        float[] xyz = new float[3];
        for (int i = 0; i < xyz.length; ++i) {
            xyz[i] = JsonUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)(key + "[" + i + "]"));
        }
        return new Vector3f(xyz[0], xyz[1], xyz[2]);
    }
}

