/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.command.argument;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.ilexiconn.llibrary.server.command.argument.IArgumentParser;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;

public enum ArgumentParsers implements IArgumentParser
{
    INTEGER{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return CommandBase.func_175755_a((String)argument);
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return Collections.emptyList();
        }
    }
    ,
    BOOLEAN{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return CommandBase.func_180527_d((String)argument);
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
    }
    ,
    STRING{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return argument;
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return Collections.emptyList();
        }
    }
    ,
    FLOAT{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return Float.valueOf((float)CommandBase.func_175765_c((String)argument));
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return Collections.emptyList();
        }
    }
    ,
    DOUBLE{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return CommandBase.func_175765_c((String)argument);
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return Collections.emptyList();
        }
    }
    ,
    PLAYER{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return CommandBase.func_82359_c((ICommandSender)sender, (String)argument);
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
    }
    ,
    ITEM_STACK{

        public Object parseArgument(MinecraftServer server, ICommandSender sender, String argument) throws CommandException {
            return new ItemStack(CommandBase.func_147179_f((ICommandSender)sender, (String)argument));
        }

        @Override
        public List<String> getTabCompletion(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return CommandBase.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b());
        }
    };


    public static <T> IArgumentParser<T> getBuiltinParser(Class<T> type) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return INTEGER;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return BOOLEAN;
        }
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return FLOAT;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return DOUBLE;
        }
        if (EntityPlayer.class.isAssignableFrom(type)) {
            return PLAYER;
        }
        if (ItemStack.class.isAssignableFrom(type)) {
            return ITEM_STACK;
        }
        return null;
    }
}

