/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameData;

public class ModUtils {
    private static Map<String, ModContainer> resourceIDToContainerMap = new HashMap<String, ModContainer>();

    public static String getModNameForStack(ItemStack stack) {
        return ModUtils.getModNameForItem(stack.func_77973_b());
    }

    public static String getModNameForBlock(Block block) {
        return ModUtils.getModNameForItem(Item.func_150898_a((Block)block));
    }

    public static String getModNameForItem(Item item) {
        ResourceLocation resourceLocation = GameData.getItemRegistry().getNameForObject((Object)item);
        String modID = resourceLocation.func_110624_b();
        String resourceID = modID.toLowerCase(Locale.ENGLISH);
        return ModUtils.getNameForResourceID(resourceID);
    }

    public static String getNameForResourceID(String resourceID) {
        return resourceIDToContainerMap.get(resourceID).getName();
    }

    public static ModContainer getContainerForStack(ItemStack stack) {
        return ModUtils.getContainerForItem(stack.func_77973_b());
    }

    public static ModContainer getContainerForBlock(Block block) {
        return ModUtils.getContainerForItem(Item.func_150898_a((Block)block));
    }

    public static ModContainer getContainerForItem(Item item) {
        ResourceLocation resourceLocation = GameData.getItemRegistry().getNameForObject((Object)item);
        String modID = resourceLocation.func_110624_b();
        String resourceID = modID.toLowerCase(Locale.ENGLISH);
        return ModUtils.getContainerForResourceID(resourceID);
    }

    public static ModContainer getContainerForResourceID(String resourceID) {
        return resourceIDToContainerMap.get(resourceID);
    }

    static {
        resourceIDToContainerMap.put("minecraft", (ModContainer)Loader.instance().getMinecraftModContainer());
        Map map = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : map.entrySet()) {
            String resourceID = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            ModContainer modContainer = (ModContainer)modEntry.getValue();
            resourceIDToContainerMap.put(resourceID, modContainer);
        }
    }
}

