/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.capability;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.capability.EntityDataHandler;
import net.ilexiconn.llibrary.server.capability.IEntityData;
import net.ilexiconn.llibrary.server.capability.IEntityDataCapability;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityDataCapabilityImplementation
implements IEntityDataCapability {
    private Entity entity;

    public static IEntityDataCapability getCapability(Entity entity) {
        return (IEntityDataCapability)entity.getCapability(LLibrary.ENTITY_DATA_CAPABILITY, null);
    }

    @Override
    public void init(Entity entity, World world, boolean init) {
        this.entity = entity;
        if (init) {
            for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(entity)) {
                entityData.init(entity, world);
            }
        }
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(this.entity)) {
            NBTTagCompound managerTag = new NBTTagCompound();
            entityData.saveNBTData(managerTag);
            compound.func_74782_a(entityData.getID(), (NBTBase)managerTag);
        }
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(this.entity)) {
            NBTTagCompound managerTag = compound.func_74775_l(entityData.getID());
            entityData.loadNBTData(managerTag);
        }
    }
}

