/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.tabula;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tabula.baked.VanillaTabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.baked.deserializer.ItemCameraTransformsDeserializer;
import net.ilexiconn.llibrary.client.model.tabula.baked.deserializer.ItemTransformVec3fDeserializer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeGroupContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum TabulaModelHandler implements ICustomModelLoader,
JsonDeserializationContext
{
    INSTANCE;

    private Gson gson = new GsonBuilder().registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3fDeserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransformsDeserializer()).create();
    private JsonParser parser = new JsonParser();
    private ModelBlock.Deserializer modelBlockDeserializer = new ModelBlock.Deserializer();
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        LLibrary.LOGGER.info("TabulaModelHandler: Domain %s has been added.", new Object[]{domain.toLowerCase()});
    }

    public TabulaModelContainer loadTabulaModel(String path) throws IOException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith(".tbl")) {
            path = path + ".tbl";
        }
        InputStream stream = TabulaModelHandler.class.getResourceAsStream(path);
        return INSTANCE.loadTabulaModel(this.getModelJsonStream(path, stream));
    }

    public TabulaModelContainer loadTabulaModel(InputStream stream) {
        return (TabulaModelContainer)this.gson.fromJson((Reader)new InputStreamReader(stream), TabulaModelContainer.class);
    }

    public TabulaCubeContainer getCubeByName(String name, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = this.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getName().equals(name)) continue;
            return cube;
        }
        return null;
    }

    public TabulaCubeContainer getCubeByIdentifier(String identifier, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = this.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getIdentifier().equals(identifier)) continue;
            return cube;
        }
        return null;
    }

    public List<TabulaCubeContainer> getAllCubes(TabulaModelContainer model) {
        ArrayList<TabulaCubeContainer> cubes = new ArrayList<TabulaCubeContainer>();
        for (TabulaCubeGroupContainer cubeGroup : model.getCubeGroups()) {
            cubes.addAll(this.traverse(cubeGroup));
        }
        for (TabulaCubeContainer cube : model.getCubes()) {
            cubes.addAll(this.traverse(cube));
        }
        return cubes;
    }

    private List<TabulaCubeContainer> traverse(TabulaCubeGroupContainer group) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        for (TabulaCubeContainer tabulaCubeContainer : group.getCubes()) {
            retCubes.addAll(this.traverse(tabulaCubeContainer));
        }
        for (TabulaCubeGroupContainer tabulaCubeGroupContainer : group.getCubeGroups()) {
            retCubes.addAll(this.traverse(tabulaCubeGroupContainer));
        }
        return retCubes;
    }

    private List<TabulaCubeContainer> traverse(TabulaCubeContainer cube) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        retCubes.add(cube);
        for (TabulaCubeContainer child : cube.getChildren()) {
            retCubes.addAll(this.traverse(child));
        }
        return retCubes;
    }

    public void func_110549_a(IResourceManager manager) {
        this.manager = manager;
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".tbl");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        String texture;
        String modelPath = modelLocation.func_110623_a();
        modelPath = modelPath.substring(0, modelPath.lastIndexOf(46)) + ".json";
        IResource resource = this.manager.func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), modelPath));
        InputStreamReader jsonStream = new InputStreamReader(resource.func_110527_b());
        JsonElement json = this.parser.parse((Reader)jsonStream);
        jsonStream.close();
        ModelBlock modelBlock = this.modelBlockDeserializer.deserialize(json, ModelBlock.class, (JsonDeserializationContext)this);
        String tblLocationStr = json.getAsJsonObject().get("tabula").getAsString() + ".tbl";
        ResourceLocation tblLocation = new ResourceLocation(tblLocationStr);
        IResource tblResource = this.manager.func_110536_a(tblLocation);
        InputStream modelStream = this.getModelJsonStream(tblLocation.toString(), tblResource.func_110527_b());
        TabulaModelContainer modelJson = INSTANCE.loadTabulaModel(modelStream);
        modelStream.close();
        ImmutableList.Builder builder = ImmutableList.builder();
        int layer = 0;
        while ((texture = (String)modelBlock.field_178318_c.get("layer" + layer++)) != null) {
            builder.add((Object)new ResourceLocation(texture));
        }
        String particle = (String)modelBlock.field_178318_c.get("particle");
        return new VanillaTabulaModel(modelJson, particle != null ? new ResourceLocation(particle) : null, (ImmutableList<ResourceLocation>)builder.build(), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)modelBlock.func_181682_g()));
    }

    private InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        while ((entry = zip.getNextEntry()) != null) {
            if (!entry.getName().equals("model.json")) continue;
            return zip;
        }
        throw new RuntimeException("No model.json present in " + name);
    }

    public <T> T deserialize(JsonElement json, Type type) throws JsonParseException {
        return (T)this.gson.fromJson(json, type);
    }
}

