/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.server.asm.MappingHandler;

public class Descriptors {
    private static final Map<String, String> PRIMITIVE_NAMES = new HashMap<String, String>();

    public static String method(Object ... params) {
        if (params.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < params.length - 1; ++i) {
            Object obj = params[i];
            if (obj instanceof Integer) {
                String desc = Descriptors.field(params[++i]);
                int k = (Integer)obj;
                for (int j = 0; j < k; ++j) {
                    builder.append(desc);
                }
                continue;
            }
            builder.append(Descriptors.field(obj));
        }
        builder.append(")").append(Descriptors.field(params[params.length - 1]));
        return builder.toString();
    }

    public static String field(Object obj) {
        Object cls;
        String result = "";
        String suffix = "";
        if (obj instanceof String) {
            cls = MappingHandler.INSTANCE.getClassMapping((String)obj);
            result = PRIMITIVE_NAMES.get(cls);
            if (result == null) {
                result = "L" + (String)cls;
                suffix = ";";
            }
        } else if (obj instanceof Class && (result = PRIMITIVE_NAMES.get(((Class)(cls = (Class)obj)).getName())) == null) {
            if (!((Class)cls).isArray()) {
                return "L" + ((Class)cls).getName() + ";";
            }
            return ((Class)cls).getName();
        }
        while (result.endsWith("[]")) {
            result = "[" + result.substring(0, result.length() - 2);
        }
        return result + suffix;
    }

    static {
        PRIMITIVE_NAMES.put("void", "V");
        PRIMITIVE_NAMES.put("boolean", "Z");
        PRIMITIVE_NAMES.put("char", "C");
        PRIMITIVE_NAMES.put("byte", "B");
        PRIMITIVE_NAMES.put("short", "S");
        PRIMITIVE_NAMES.put("int", "I");
        PRIMITIVE_NAMES.put("float", "F");
        PRIMITIVE_NAMES.put("long", "J");
        PRIMITIVE_NAMES.put("double", "D");
    }
}

