/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.access;

import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.sizechange.ISizeChangeCapability;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Hooks {
    private Hooks() {
    }

    public static float getSize(Entity entity) {
        if (!entity.hasCapability(LucraftCore.SIZECHANGE_CAP, null)) {
            return 1.0f;
        }
        return ((ISizeChangeCapability)entity.getCapability(LucraftCore.SIZECHANGE_CAP, null)).getSize();
    }

    @SideOnly(value=Side.CLIENT)
    public static float getRenderSize(Entity entity, float partialTick) {
        if (!entity.hasCapability(LucraftCore.SIZECHANGE_CAP, null)) {
            return 1.0f;
        }
        return ((ISizeChangeCapability)entity.getCapability(LucraftCore.SIZECHANGE_CAP, null)).getRenderSize(partialTick);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getScreenInterpEyeHeight(Entity entity, float partialTick) {
        return entity.func_70047_e() / Hooks.getSize(entity) * Hooks.getRenderSize(entity, partialTick);
    }

    public static void updateSize(Entity entity) {
        ((ISizeChangeCapability)entity.getCapability(LucraftCore.SIZECHANGE_CAP, null)).tick(entity);
    }

    public static float getLabelHeight(Entity entity, float old) {
        float off = entity.func_70093_af() ? 0.25f : 0.5f;
        return (old - off) / Hooks.getSize(entity) + off;
    }

    public static boolean cancelRunningParticlesHook(Entity entity) {
        return Hooks.getSize(entity) <= 0.25f;
    }

    public static boolean cancelBlockCollision(Entity entity, IBlockState state, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150427_aO && Hooks.getSize(entity) < 1.0f && !entity.func_174813_aQ().func_72326_a(state.func_185918_c(entity.field_70170_p, pos));
    }
}

